/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.items;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lyeoj.tfcthings.init.TFCThingsItems;
import lyeoj.tfcthings.items.TFCThingsConfigurableItem;
import net.dries007.tfc.api.capability.forge.ForgeableHeatableHandler;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.CreativeTabsTFC;
import net.dries007.tfc.objects.items.ItemTFC;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemTFCThingsToolHead
extends ItemTFC
implements IMetalItem,
TFCThingsConfigurableItem {
    private final Metal metal;
    private final int smeltAmount;
    private boolean isEnabled;

    public ItemTFCThingsToolHead(Metal metal, int smeltAmount, boolean enabled, String ... name) {
        this.metal = metal;
        this.smeltAmount = smeltAmount;
        this.isEnabled = enabled;
        String registryName = "";
        String translationKey = "";
        if (TFCThingsItems.TOOLS_HEADS_BY_METAL.containsKey(name[0])) {
            TFCThingsItems.TOOLS_HEADS_BY_METAL.get(name[0]).put(metal, (Item)this);
        } else {
            HashMap<Metal, ItemTFCThingsToolHead> toolMap = new HashMap<Metal, ItemTFCThingsToolHead>();
            toolMap.put(metal, this);
            TFCThingsItems.TOOLS_HEADS_BY_METAL.put(name[0], toolMap);
        }
        for (int i = 0; i < name.length; ++i) {
            registryName = registryName + name[i];
            translationKey = translationKey + name[i];
            if (i + 1 >= name.length) continue;
            registryName = registryName + "/";
            translationKey = translationKey + "_";
        }
        this.setRegistryName(registryName);
        this.func_77655_b(translationKey);
        this.func_77637_a(CreativeTabsTFC.CT_METAL);
    }

    @Nullable
    public Metal getMetal(ItemStack itemStack) {
        return this.metal;
    }

    public int getSmeltAmount(ItemStack itemStack) {
        return this.smeltAmount;
    }

    public boolean canMelt(ItemStack stack) {
        return true;
    }

    @Nonnull
    public Size getSize(@Nonnull ItemStack itemStack) {
        return Size.SMALL;
    }

    @Nonnull
    public Weight getWeight(@Nonnull ItemStack itemStack) {
        return Weight.LIGHT;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ForgeableHeatableHandler(nbt, this.metal.getSpecificHeat(), this.metal.getMeltTemp());
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }
}

