/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.items;

import javax.annotation.Nonnull;
import lyeoj.tfcthings.items.TFCThingsConfigurableItem;
import lyeoj.tfcthings.main.ConfigTFCThings;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.damage.IDamageResistance;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.IArmorMaterialTFC;
import net.dries007.tfc.objects.blocks.BlockSnowTFC;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemSnowShoes
extends ItemArmor
implements IItemSize,
IDamageResistance,
TFCThingsConfigurableItem {
    private IArmorMaterialTFC materialTFC;
    private static final String STEPS_NBT_KEY = "Steps";
    private double posX;
    private double posZ;

    public ItemSnowShoes(IArmorMaterialTFC materialTFC, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialTFC.getMaterial(), renderIndexIn, equipmentSlotIn);
        this.func_77655_b("snow_shoes");
        this.setRegistryName("snow_shoes");
        this.materialTFC = materialTFC;
        this.setNoRepair();
    }

    public float getCrushingModifier() {
        return this.materialTFC.getCrushingModifier();
    }

    public float getPiercingModifier() {
        return this.materialTFC.getPiercingModifier();
    }

    public float getSlashingModifier() {
        return this.materialTFC.getSlashingModifier();
    }

    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return Size.LARGE;
    }

    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return Weight.HEAVY;
    }

    public boolean canStack(@Nonnull ItemStack stack) {
        return false;
    }

    public int getSteps(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b(STEPS_NBT_KEY)) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e(STEPS_NBT_KEY);
    }

    public void setSteps(ItemStack stack, int steps) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(STEPS_NBT_KEY, steps);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (this.getSteps(itemStack) > ConfigTFCThings.Items.SNOW_SHOES.damageTicks && !world.field_72995_K) {
            itemStack.func_77972_a(1, (EntityLivingBase)player);
            this.setSteps(itemStack, 0);
        }
        if (player.field_70122_E && !player.func_184218_aH() && !player.func_184812_l_()) {
            AxisAlignedBB axisalignedbb = player.func_174813_aQ();
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185345_c((double)(axisalignedbb.field_72340_a + 0.001), (double)(axisalignedbb.field_72338_b + 0.001), (double)(axisalignedbb.field_72339_c + 0.001));
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos1 = BlockPos.PooledMutableBlockPos.func_185345_c((double)(axisalignedbb.field_72336_d - 0.001), (double)(axisalignedbb.field_72337_e - 0.001), (double)(axisalignedbb.field_72334_f - 0.001));
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos2 = BlockPos.PooledMutableBlockPos.func_185346_s();
            if (player.field_70170_p.func_175707_a((BlockPos)blockpos$pooledmutableblockpos, (BlockPos)blockpos$pooledmutableblockpos1)) {
                for (int i = blockpos$pooledmutableblockpos.func_177958_n(); i <= blockpos$pooledmutableblockpos1.func_177958_n(); ++i) {
                    for (int j = blockpos$pooledmutableblockpos.func_177956_o(); j <= blockpos$pooledmutableblockpos1.func_177956_o(); ++j) {
                        for (int k = blockpos$pooledmutableblockpos.func_177952_p(); k <= blockpos$pooledmutableblockpos1.func_177952_p(); ++k) {
                            blockpos$pooledmutableblockpos2.func_181079_c(i, j, k);
                            IBlockState iblockstate = world.func_180495_p((BlockPos)blockpos$pooledmutableblockpos2);
                            if (!(iblockstate.func_177230_c() instanceof BlockSnowTFC)) continue;
                            double speedModifier = ConfigTFC.General.MISC.snowMovementModifier + (1.0 - ConfigTFC.General.MISC.snowMovementModifier) * ConfigTFCThings.Items.SNOW_SHOES.shoePower;
                            player.field_70159_w /= ConfigTFC.General.MISC.snowMovementModifier;
                            player.field_70179_y /= ConfigTFC.General.MISC.snowMovementModifier;
                            player.field_70159_w *= speedModifier;
                            player.field_70179_y *= speedModifier;
                            if (world.field_72995_K || ConfigTFCThings.Items.SNOW_SHOES.damageTicks <= 0 || this.posX == player.field_70165_t && this.posZ == player.field_70161_v) continue;
                            this.setSteps(itemStack, this.getSteps(itemStack) + 1);
                            this.posX = player.field_70165_t;
                            this.posZ = player.field_70161_v;
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ConfigTFCThings.Items.MASTER_ITEM_LIST.enableSnowShoes;
    }
}

