/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lyeoj.tfcthings.entity.projectile.EntitySlingStone;
import lyeoj.tfcthings.entity.projectile.EntityUnknownProjectile;
import lyeoj.tfcthings.items.ItemOreDict;
import lyeoj.tfcthings.items.TFCThingsConfigurableItem;
import lyeoj.tfcthings.main.ConfigTFCThings;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.CreativeTabsTFC;
import net.dries007.tfc.objects.items.metal.ItemIngot;
import net.dries007.tfc.objects.items.rock.ItemRock;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemSling
extends Item
implements IItemSize,
ItemOreDict,
TFCThingsConfigurableItem {
    private int tier;

    public ItemSling(int tier) {
        this.tier = tier;
        if (tier < 1) {
            this.func_77656_e(64);
        } else {
            this.func_77656_e(256);
        }
        this.setNoRepair();
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabsTFC.CT_MISC);
        this.func_185043_a(new ResourceLocation("spinning"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack && entityIn.func_184612_cw() > 0) {
                    int maxPower = ConfigTFCThings.Items.SLING.maxPower;
                    int chargeSpeed = ConfigTFCThings.Items.SLING.chargeSpeed;
                    float powerRatio = Math.min((float)entityIn.func_184612_cw() / (float)chargeSpeed, (float)maxPower) / (float)maxPower;
                    float f = MathHelper.func_76141_d((float)((float)entityIn.func_184612_cw() * powerRatio % 8.0f + 1.0f));
                    return f;
                }
                return 0.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @Nonnull
    public Size getSize(@Nonnull ItemStack itemStack) {
        return Size.NORMAL;
    }

    @Nonnull
    public Weight getWeight(@Nonnull ItemStack itemStack) {
        return Weight.MEDIUM;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        boolean flag;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        boolean bl = flag = !this.findAmmo(playerIn).func_190926_b();
        if (!playerIn.func_184812_l_() && !flag) {
            return flag ? new ActionResult(EnumActionResult.PASS, (Object)itemstack) : new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            boolean flag = entityplayer.func_184812_l_();
            ItemStack itemStack = this.findAmmo(entityplayer);
            int maxPower = ConfigTFCThings.Items.SLING.maxPower;
            int chargeSpeed = ConfigTFCThings.Items.SLING.chargeSpeed;
            int power = Math.min((this.func_77626_a(stack) - timeLeft) / chargeSpeed, maxPower);
            float velocity = 1.6f * ((float)power / (float)maxPower);
            float inaccuracy = 0.5f * (8.0f - (float)power);
            if (!itemStack.func_190926_b() && !flag) {
                if (!worldIn.field_72995_K) {
                    this.shoot(worldIn, entityLiving, power, velocity, inaccuracy, itemStack);
                }
                worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187797_fA, SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                itemStack.func_190918_g(1);
                if (itemStack.func_190926_b()) {
                    entityplayer.field_71071_by.func_184437_d(itemStack);
                }
                stack.func_77972_a(1, (EntityLivingBase)entityplayer);
            } else if (flag) {
                if (!worldIn.field_72995_K) {
                    this.shoot(worldIn, entityLiving, power, velocity, inaccuracy, itemStack);
                }
                worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187797_fA, SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            }
        }
    }

    private void shoot(World worldIn, EntityLivingBase entityLiving, int power, float velocity, float inaccuracy, ItemStack itemStack) {
        EntitySlingStone entitySlingStone = itemStack.func_77973_b() instanceof ItemIngot ? new EntityUnknownProjectile(worldIn, entityLiving, power) : new EntitySlingStone(worldIn, entityLiving, power);
        entitySlingStone.func_184538_a((Entity)entityLiving, entityLiving.field_70125_A, entityLiving.field_70177_z, 0.0f, velocity, inaccuracy);
        worldIn.func_72838_d((Entity)entitySlingStone);
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.isStone(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isStone(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isStone(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isStone(ItemStack stack) {
        ItemIngot ingot;
        if (stack.func_77973_b() instanceof ItemRock) {
            return true;
        }
        return stack.func_77973_b() instanceof ItemIngot && (ingot = (ItemIngot)stack.func_77973_b()).getMetal(stack) == Metal.UNKNOWN;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.tier < 1) {
            tooltip.add(I18n.func_135052_a((String)"tfcthings.tooltip.sling.message1", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tfcthings.tooltip.sling.message2", (Object[])new Object[0]));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public void initOreDict() {
        OreDictionary.registerOre((String)"tool", (ItemStack)new ItemStack((Item)this, 1, Short.MAX_VALUE));
    }

    @Override
    public boolean isEnabled() {
        return ConfigTFCThings.Items.MASTER_ITEM_LIST.enableSling;
    }
}

