/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lyeoj.tfcthings.entity.projectile.EntityThrownRopeJavelin;
import lyeoj.tfcthings.items.ItemOreDict;
import lyeoj.tfcthings.items.TFCThingsConfigurableItem;
import lyeoj.tfcthings.main.ConfigTFCThings;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.CreativeTabsTFC;
import net.dries007.tfc.objects.items.ItemTFC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemRopeJavelin
extends ItemTFC
implements IMetalItem,
ItemOreDict,
TFCThingsConfigurableItem {
    private final Metal metal;
    public final Item.ToolMaterial material;
    protected final double attackDamage;
    protected final float attackSpeed;
    protected double pullStrength = 0.1;
    private static final String THROWN_NBT_KEY = "Thrown";
    private static final String JAVELIN_NBT_KEY = "JavelinID";
    private static final String CAPTURED_NBT_KEY = "CapturedID";

    public ItemRopeJavelin(Metal metal, String name) {
        this.metal = metal;
        this.material = metal.getToolMetal();
        this.func_77637_a(CreativeTabsTFC.CT_METAL);
        this.func_77656_e((int)((double)this.material.func_77997_a() * 0.1));
        this.attackDamage = 0.7 * (double)this.material.func_78000_c();
        this.attackSpeed = -1.8f;
        this.func_77655_b(this.getNamePrefix() + "_" + name);
        this.setRegistryName(this.getNamePrefix() + "/" + name);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("thrown"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                boolean flag1;
                if (entityIn == null) {
                    return 0.0f;
                }
                boolean flag = entityIn.func_184614_ca() == stack;
                boolean bl = flag1 = entityIn.func_184592_cb() == stack;
                if (entityIn.func_184614_ca().func_77973_b() instanceof ItemRopeJavelin) {
                    flag1 = false;
                }
                return (flag || flag1) && entityIn instanceof EntityPlayer && ItemRopeJavelin.this.isThrown(stack) ? 1.0f : 0.0f;
            }
        });
    }

    protected String getNamePrefix() {
        return "rope_javelin";
    }

    @Nullable
    public Metal getMetal(ItemStack itemStack) {
        return this.metal;
    }

    public int getSmeltAmount(ItemStack itemStack) {
        return 100;
    }

    @Nonnull
    public Size getSize(@Nonnull ItemStack itemStack) {
        return Size.NORMAL;
    }

    @Nonnull
    public Weight getWeight(@Nonnull ItemStack itemStack) {
        return Weight.MEDIUM;
    }

    public boolean canStack(ItemStack itemStack) {
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND && !this.isThrown(stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.attackSpeed, 0));
        }
        return multimap;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (this.isThrown(itemstack)) {
            EntityThrownRopeJavelin javelin = this.getJavelin(itemstack, worldIn);
            if (javelin != null && this.getCapturedEntity(itemstack, worldIn) != null) {
                Entity entity = this.getCapturedEntity(itemstack, worldIn);
                if (entity.func_184218_aH()) {
                    entity.func_184210_p();
                }
                double d0 = playerIn.field_70165_t - javelin.field_70165_t;
                double d1 = playerIn.field_70163_u - javelin.field_70163_u;
                double d2 = playerIn.field_70161_v - javelin.field_70161_v;
                entity.field_70159_w += d0 * this.pullStrength;
                entity.field_70181_x += d1 * this.pullStrength;
                entity.field_70179_y += d2 * this.pullStrength;
            }
            this.retractJavelin(itemstack, worldIn);
        } else {
            playerIn.func_184598_c(handIn);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return this.isThrown(stack) ? EnumAction.NONE : EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            int charge = this.func_77626_a(stack) - timeLeft;
            if (charge > 5) {
                float f = ItemBow.func_185059_b((int)charge);
                if (!worldIn.field_72995_K) {
                    this.setThrown(stack, true);
                    EntityThrownRopeJavelin javelin = this.makeNewJavelin(worldIn, player);
                    javelin.func_70239_b(this.attackDamage);
                    javelin.setWeapon(stack);
                    javelin.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 1.5f, 0.5f);
                    this.setJavelin(stack, javelin);
                    this.getJavelin(stack, worldIn);
                    worldIn.func_72838_d((Entity)javelin);
                    worldIn.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, TFCSounds.ITEM_THROW, SoundCategory.PLAYERS, 1.0f, 1.0f / (Constants.RNG.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                }
            }
        }
    }

    protected EntityThrownRopeJavelin makeNewJavelin(World worldIn, EntityPlayer player) {
        return new EntityThrownRopeJavelin(worldIn, (EntityLivingBase)player);
    }

    public boolean isThrown(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b(THROWN_NBT_KEY)) {
            return false;
        }
        return stack.func_77978_p().func_74767_n(THROWN_NBT_KEY);
    }

    public void setThrown(ItemStack stack, boolean thrown) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a(THROWN_NBT_KEY, thrown);
    }

    public EntityThrownRopeJavelin getJavelin(ItemStack stack, World world) {
        Entity entity;
        UUID javelinID;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((javelinID = stack.func_77978_p().func_186857_a(JAVELIN_NBT_KEY)) != null && world instanceof WorldServer && (entity = ((WorldServer)world).func_175733_a(javelinID)) instanceof EntityThrownRopeJavelin) {
            return (EntityThrownRopeJavelin)entity;
        }
        return null;
    }

    public void setJavelin(ItemStack stack, EntityThrownRopeJavelin javelin) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (javelin != null) {
            stack.func_77978_p().func_186854_a(JAVELIN_NBT_KEY, javelin.func_110124_au());
        } else {
            stack.func_77978_p().func_186854_a(JAVELIN_NBT_KEY, UUID.randomUUID());
        }
    }

    public Entity getCapturedEntity(ItemStack stack, World world) {
        UUID capturedID;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((capturedID = stack.func_77978_p().func_186857_a(CAPTURED_NBT_KEY)) != null && world instanceof WorldServer) {
            return ((WorldServer)world).func_175733_a(capturedID);
        }
        return null;
    }

    public void setCapturedEntity(ItemStack stack, Entity entity) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (entity != null) {
            stack.func_77978_p().func_186854_a(CAPTURED_NBT_KEY, entity.func_110124_au());
        } else {
            stack.func_77978_p().func_186854_a(CAPTURED_NBT_KEY, UUID.randomUUID());
        }
    }

    public void retractJavelin(ItemStack stack, World world) {
        this.setThrown(stack, false);
        this.setCapturedEntity(stack, null);
        if (this.getJavelin(stack, world) != null) {
            this.getJavelin(stack, world).func_70106_y();
            this.setJavelin(stack, null);
        }
    }

    @Override
    public void initOreDict() {
        OreDictionary.registerOre((String)"tool", (ItemStack)new ItemStack((Item)this, 1, Short.MAX_VALUE));
    }

    @Override
    public boolean isEnabled() {
        return ConfigTFCThings.Items.MASTER_ITEM_LIST.enableRopeJavelins;
    }
}

