/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lyeoj.tfcthings.items.ItemOreDict;
import lyeoj.tfcthings.items.TFCThingsConfigurableItem;
import lyeoj.tfcthings.main.ConfigTFCThings;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.forge.ForgeableHeatableHandler;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.blocks.wood.BlockSupport;
import net.dries007.tfc.objects.items.ItemTFC;
import net.dries007.tfc.util.ICollapsableBlock;
import net.dries007.tfc.util.IFallingBlock;
import net.dries007.tfc.util.skills.ProspectingSkill;
import net.dries007.tfc.util.skills.SkillType;
import net.dries007.tfc.util.skills.SmithingSkill;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.oredict.OreDictionary;

public class ItemProspectorsHammer
extends ItemTFC
implements IMetalItem,
ItemOreDict,
TFCThingsConfigurableItem {
    private final Metal metal;
    public final Item.ToolMaterial material;
    private final double attackDamage;
    private final float attackSpeed;

    public ItemProspectorsHammer(Metal metal, String name) {
        this.metal = metal;
        this.material = metal.getToolMetal();
        this.func_77656_e((int)((double)this.material.func_77997_a() / 4.0));
        this.attackDamage = 0.5 * (double)this.material.func_78000_c();
        this.attackSpeed = -2.8f;
        this.func_77625_d(1);
        this.setRegistryName("prospectors_hammer/" + name);
        this.func_77655_b("prospectors_hammer_" + name);
    }

    @Nonnull
    public Size getSize(@Nonnull ItemStack itemStack) {
        return Size.NORMAL;
    }

    @Nonnull
    public Weight getWeight(@Nonnull ItemStack itemStack) {
        return Weight.MEDIUM;
    }

    public boolean canStack(ItemStack itemStack) {
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.attackSpeed, 0));
        }
        return multimap;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, false);
        if (raytraceresult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        if (raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        BlockPos blockpos = raytraceresult.func_178782_a();
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        SoundType soundType = iblockstate.func_177230_c().getSoundType(iblockstate, worldIn, blockpos, (Entity)playerIn);
        worldIn.func_184133_a(playerIn, blockpos, soundType.func_185846_f(), SoundCategory.BLOCKS, 1.0f, soundType.func_185847_b());
        Block block = iblockstate.func_177230_c();
        if (!worldIn.field_72995_K) {
            ProspectingSkill skill = (ProspectingSkill)CapabilityPlayerData.getSkill((EntityPlayer)playerIn, (SkillType)SkillType.PROSPECTING);
            if (playerIn.func_70093_af()) {
                this.checkRockLayers(playerIn, worldIn, blockpos, skill);
                playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
                float skillModifier = SmithingSkill.getSkillBonus((ItemStack)itemstack, (SmithingSkill.Type)SmithingSkill.Type.TOOLS) / 2.0f;
                boolean flag = true;
                if (skillModifier > 0.0f && Constants.RNG.nextFloat() < skillModifier) {
                    flag = false;
                }
                if (flag) {
                    playerIn.func_184586_b(handIn).func_77972_a(20, (EntityLivingBase)playerIn);
                } else {
                    playerIn.func_184586_b(handIn).func_77972_a(10, (EntityLivingBase)playerIn);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
            int messageType = 0;
            if (block instanceof ICollapsableBlock) {
                boolean result = this.isThisBlockSafe(worldIn, blockpos);
                float falsePositiveChance = 0.3f;
                if (skill != null) {
                    falsePositiveChance = 0.3f - 0.1f * (float)skill.getTier().ordinal();
                }
                if (Math.random() < (double)falsePositiveChance) {
                    result = true;
                }
                messageType = result ? 1 : 2;
            }
            if (skill != null && skill.getTier().ordinal() > 1 && this.supportingFallable(worldIn, blockpos)) {
                messageType += 3;
            }
            switch (messageType) {
                case 0: {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.prohammer_na", new Object[0]), ConfigTFC.Client.TOOLTIP.propickOutputToActionBar);
                    break;
                }
                case 1: {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.prohammer_safe", new Object[0]), ConfigTFC.Client.TOOLTIP.propickOutputToActionBar);
                    break;
                }
                case 2: {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.prohammer_unsafe", new Object[0]), ConfigTFC.Client.TOOLTIP.propickOutputToActionBar);
                    break;
                }
                case 3: {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.prohammer_na_fall", new Object[0]), ConfigTFC.Client.TOOLTIP.propickOutputToActionBar);
                    break;
                }
                case 4: {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.prohammer_safe_fall", new Object[0]), ConfigTFC.Client.TOOLTIP.propickOutputToActionBar);
                    break;
                }
                case 5: {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.prohammer_unsafe_fall", new Object[0]), ConfigTFC.Client.TOOLTIP.propickOutputToActionBar);
                }
            }
            float skillModifier = SmithingSkill.getSkillBonus((ItemStack)itemstack, (SmithingSkill.Type)SmithingSkill.Type.TOOLS) / 2.0f;
            boolean flag = true;
            if (skillModifier > 0.0f && Constants.RNG.nextFloat() < skillModifier) {
                flag = false;
            }
            if (flag) {
                playerIn.func_184586_b(handIn).func_77972_a(1, (EntityLivingBase)playerIn);
            }
            playerIn.func_184811_cZ().func_185145_a((Item)this, 10);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    private boolean isThisBlockSafe(World worldIn, BlockPos pos) {
        int radX = (Constants.RNG.nextInt(5) + 4) / 2;
        int radY = (Constants.RNG.nextInt(3) + 2) / 2;
        int radZ = (Constants.RNG.nextInt(5) + 4) / 2;
        for (BlockPos checking : BlockSupport.getAllUnsupportedBlocksIn((World)worldIn, (BlockPos)pos.func_177982_a(-radX, -radY, -radZ), (BlockPos)pos.func_177982_a(radX, radY, radZ))) {
            ICollapsableBlock block;
            if (!(worldIn.func_180495_p(checking).func_177230_c() instanceof ICollapsableBlock) || !(block = (ICollapsableBlock)worldIn.func_180495_p(checking).func_177230_c()).canCollapse(worldIn, checking)) continue;
            return false;
        }
        return true;
    }

    private boolean supportingFallable(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177984_a());
        Block block = iblockstate.func_177230_c();
        if (block instanceof IFallingBlock || block instanceof BlockFalling) {
            return !BlockSupport.isBeingSupported((World)worldIn, (BlockPos)pos.func_177984_a());
        }
        return false;
    }

    @Nullable
    public Metal getMetal(ItemStack itemStack) {
        return this.metal;
    }

    public int getSmeltAmount(ItemStack itemStack) {
        if (this.func_77645_m() && itemStack.func_77951_h()) {
            double d = (double)(itemStack.func_77958_k() - itemStack.func_77952_i()) / (double)itemStack.func_77958_k() - 0.1;
            return d < 0.0 ? 0 : MathHelper.func_76128_c((double)(100.0 * d));
        }
        return 100;
    }

    public boolean canMelt(ItemStack stack) {
        return true;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ForgeableHeatableHandler(nbt, this.metal.getSpecificHeat(), this.metal.getMeltTemp());
    }

    @Override
    public void initOreDict() {
        OreDictionary.registerOre((String)"tool", (ItemStack)new ItemStack((Item)this, 1, Short.MAX_VALUE));
    }

    private void checkRockLayers(EntityPlayer playerIn, World worldIn, BlockPos pos, ProspectingSkill skill) {
        int skillTier = 0;
        if (skill != null) {
            skillTier = skill.getTier().ordinal();
        }
        ArrayList<Rock> rocks = new ArrayList<Rock>();
        BlockPos pos1 = pos;
        BlockPos pos2 = pos.func_177981_b(10);
        BlockPos pos3 = pos.func_177979_c(10);
        for (int i = 0; i < skillTier + 1; ++i) {
            this.addRock(pos1, rocks, worldIn);
            this.addRock(pos2, rocks, worldIn);
            this.addRock(pos3, rocks, worldIn);
            pos1 = pos1.func_177979_c(30);
            pos2 = pos2.func_177979_c(30);
            pos3 = pos3.func_177979_c(30);
        }
        if (rocks.isEmpty()) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.prohammer_no_rocks", new Object[0]), ConfigTFC.Client.TOOLTIP.propickOutputToActionBar);
        } else if (rocks.size() == 1) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.prohammer_1_rock_found", new Object[]{rocks.get(0).toString()}), ConfigTFC.Client.TOOLTIP.propickOutputToActionBar);
        } else if (rocks.size() == 2) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.prohammer_2_rocks_found", new Object[]{rocks.get(0).toString(), rocks.get(1).toString()}), ConfigTFC.Client.TOOLTIP.propickOutputToActionBar);
        } else if (rocks.size() >= 3) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.prohammer_3_rocks_found", new Object[]{rocks.get(0).toString(), rocks.get(1).toString(), rocks.get(2).toString()}), ConfigTFC.Client.TOOLTIP.propickOutputToActionBar);
        }
    }

    private void addRock(BlockPos pos, List<Rock> rocks, World worldIn) {
        Rock rock;
        if (worldIn.func_180495_p(pos).func_177230_c() instanceof BlockRockVariant && !rocks.contains(rock = ((BlockRockVariant)worldIn.func_180495_p(pos).func_177230_c()).getRock())) {
            rocks.add(rock);
        }
    }

    @Override
    public boolean isEnabled() {
        return ConfigTFCThings.Items.MASTER_ITEM_LIST.enableProspectorsHammer;
    }
}

