/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import javax.annotation.Nonnull;
import lyeoj.tfcthings.entity.projectile.EntityThrownHookJavelin;
import lyeoj.tfcthings.entity.projectile.EntityThrownRopeJavelin;
import lyeoj.tfcthings.items.ItemRopeJavelin;
import lyeoj.tfcthings.items.TFCThingsConfigurableItem;
import lyeoj.tfcthings.main.ConfigTFCThings;
import net.dries007.tfc.api.types.Metal;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemHookJavelin
extends ItemRopeJavelin
implements TFCThingsConfigurableItem {
    public ItemHookJavelin(Metal metal, String name) {
        super(metal, name);
        this.func_77656_e((int)((double)this.material.func_77997_a() * 0.3));
        this.pullStrength = 0.2;
    }

    @Override
    protected EntityThrownRopeJavelin makeNewJavelin(World worldIn, EntityPlayer player) {
        return new EntityThrownHookJavelin(worldIn, (EntityLivingBase)player);
    }

    @Override
    protected String getNamePrefix() {
        return "hook_javelin";
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        if (!playerIn.field_70122_E) {
            ItemStack itemstack = playerIn.func_184586_b(handIn);
            if (this.isThrown(itemstack) && this.getCapturedEntity(itemstack, worldIn) == null) {
                if (this.getJavelin(itemstack, worldIn) != null) {
                    EntityThrownHookJavelin javelin = (EntityThrownHookJavelin)this.getJavelin(itemstack, worldIn);
                    javelin.setLength(javelin.getLength() - 0.5f);
                    if (playerIn.func_70093_af()) {
                        this.dismountHookedPlayer(playerIn);
                        this.retractJavelin(itemstack, worldIn);
                    }
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private void dismountHookedPlayer(EntityPlayer playerIn) {
        double d1 = playerIn.field_70165_t;
        double d13 = playerIn.field_70163_u;
        double d14 = playerIn.field_70161_v;
        EnumFacing enumfacing1 = playerIn.func_184172_bi();
        if (enumfacing1 != null) {
            EnumFacing enumfacing = enumfacing1.func_176746_e();
            int[][] aint1 = new int[][]{{0, 1}, {0, -1}, {-1, 1}, {-1, -1}, {1, 1}, {1, -1}, {-1, 0}, {1, 0}, {0, 2}, {0, -2}, {-1, 2}, {-1, -2}, {1, 2}, {1, -2}, {2, 2}, {2, -2}, {-2, 2}, {-2, -2}, {2, 0}, {2, 1}, {2, -1}, {-2, 0}, {-2, 1}, {-2, -1}};
            double d5 = Math.floor(playerIn.field_70165_t) + 0.5;
            double d6 = Math.floor(playerIn.field_70161_v) + 0.5;
            double d7 = playerIn.func_174813_aQ().field_72336_d - playerIn.func_174813_aQ().field_72340_a;
            double d8 = playerIn.func_174813_aQ().field_72334_f - playerIn.func_174813_aQ().field_72339_c;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(d5 - d7 / 2.0, playerIn.func_174813_aQ().field_72338_b, d6 - d8 / 2.0, d5 + d7 / 2.0, Math.floor(playerIn.func_174813_aQ().field_72338_b) + (double)playerIn.field_70131_O, d6 + d8 / 2.0);
            for (int[] aint : aint1) {
                double d9 = enumfacing1.func_82601_c() * aint[0] + enumfacing.func_82601_c() * aint[1];
                double d10 = enumfacing1.func_82599_e() * aint[0] + enumfacing.func_82599_e() * aint[1];
                double d11 = d5 + d9;
                double d12 = d6 + d10;
                AxisAlignedBB axisalignedbb1 = axisalignedbb.func_72317_d(d9, 0.0, d10);
                if (!playerIn.field_70170_p.func_184143_b(axisalignedbb1)) {
                    BlockPos blockpos = new BlockPos(d11, playerIn.field_70163_u, d12);
                    if (playerIn.field_70170_p.func_180495_p(blockpos).isSideSolid((IBlockAccess)playerIn.field_70170_p, blockpos, EnumFacing.UP)) {
                        playerIn.func_70634_a(d11, playerIn.field_70163_u + 1.0, d12);
                        return;
                    }
                    blockpos = new BlockPos(d11, playerIn.field_70163_u - 1.0, d12);
                    if (!playerIn.field_70170_p.func_180495_p(blockpos).isSideSolid((IBlockAccess)playerIn.field_70170_p, blockpos, EnumFacing.UP) && playerIn.field_70170_p.func_180495_p(blockpos).func_185904_a() != Material.field_151586_h) continue;
                    d1 = d11;
                    d13 = playerIn.field_70163_u + 1.0;
                    d14 = d12;
                    continue;
                }
                if (playerIn.field_70170_p.func_184143_b(axisalignedbb1.func_72317_d(0.0, 2.0, 0.0))) continue;
                BlockPos blockPos = new BlockPos(d11, playerIn.field_70163_u + 1.0, d12);
                if (playerIn.field_70170_p.func_180495_p(blockPos).isSideSolid((IBlockAccess)playerIn.field_70170_p, blockPos, EnumFacing.UP)) {
                    playerIn.func_70634_a(d11, playerIn.field_70163_u + 2.0, d12);
                    return;
                }
                blockPos = new BlockPos(d11, playerIn.field_70163_u, d12);
                if (!playerIn.field_70170_p.func_180495_p(blockPos).isSideSolid((IBlockAccess)playerIn.field_70170_p, blockPos, EnumFacing.UP)) continue;
                playerIn.func_70634_a(d11, playerIn.field_70163_u + 1.2, d12);
                return;
            }
        }
        playerIn.func_70634_a(d1, d13, d14);
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND && !this.isThrown(stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", this.attackDamage * 0.4, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.attackSpeed, 0));
        }
        return multimap;
    }

    @Override
    public boolean isEnabled() {
        return ConfigTFCThings.Items.MASTER_ITEM_LIST.enableHookJavelins;
    }
}

