/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.event;

import javax.annotation.Nullable;
import lyeoj.tfcthings.capability.CapabilitySharpness;
import lyeoj.tfcthings.capability.ISharpness;
import lyeoj.tfcthings.entity.projectile.EntityThrownRopeJavelin;
import lyeoj.tfcthings.items.ItemRopeJavelin;
import lyeoj.tfcthings.main.ConfigTFCThings;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.dries007.tfc.objects.blocks.wood.BlockToolRack;
import net.dries007.tfc.objects.entity.projectile.EntityThrownWeapon;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="tfcthings")
public class TFCThingsEventHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void applyTooltip(ItemTooltipEvent event) {
        ISharpness capability;
        if (event.getItemStack().hasCapability(CapabilitySharpness.SHARPNESS_CAPABILITY, null) && (capability = TFCThingsEventHandler.getSharpnessCapability(event.getItemStack())) != null && capability.getCharges() > 0) {
            TextFormatting color = capability.getCharges() > 64 ? (capability.getCharges() > 256 ? TextFormatting.DARK_PURPLE : TextFormatting.BLUE) : TextFormatting.DARK_GREEN;
            event.getToolTip().add(I18n.func_135052_a((String)"tfcthings.tooltip.sharpness", (Object[])new Object[]{color, "" + capability.getCharges()}));
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        ISharpness capability;
        if (event.getPlayer().func_184614_ca().hasCapability(CapabilitySharpness.SHARPNESS_CAPABILITY, null) && (capability = TFCThingsEventHandler.getSharpnessCapability(event.getPlayer().func_184614_ca())) != null && capability.getCharges() > 0) {
            capability.removeCharge();
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingDamageEvent event) {
        EntityDamageSource source;
        if (event.getSource() instanceof EntityDamageSource && (source = (EntityDamageSource)event.getSource()).func_76346_g() instanceof EntityPlayer) {
            ISharpness capability;
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            ItemStack weapon = source instanceof EntityDamageSourceIndirect && source.func_76364_f() instanceof EntityThrownWeapon ? ((EntityThrownWeapon)source.func_76364_f()).getWeapon() : (source instanceof EntityDamageSourceIndirect && source.func_76364_f() instanceof EntityThrownWeapon ? ((EntityThrownRopeJavelin)source.func_76364_f()).getWeapon() : player.func_184614_ca());
            if (weapon.hasCapability(CapabilitySharpness.SHARPNESS_CAPABILITY, null) && (capability = TFCThingsEventHandler.getSharpnessCapability(weapon)) != null && event.getAmount() > 2.0f) {
                if (capability.getCharges() > 256) {
                    event.setAmount(event.getAmount() + (float)(ConfigTFCThings.Items.WHETSTONE.damageBoost * 3));
                    capability.removeCharge();
                } else if (capability.getCharges() > 64) {
                    event.setAmount(event.getAmount() + (float)(ConfigTFCThings.Items.WHETSTONE.damageBoost * 2));
                    capability.removeCharge();
                } else if (capability.getCharges() > 0) {
                    event.setAmount(event.getAmount() + (float)ConfigTFCThings.Items.WHETSTONE.damageBoost);
                    capability.removeCharge();
                }
            }
        }
    }

    @SubscribeEvent
    public static void modifyBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getEntityPlayer().func_184614_ca().hasCapability(CapabilitySharpness.SHARPNESS_CAPABILITY, null)) {
            ISharpness capability = TFCThingsEventHandler.getSharpnessCapability(event.getEntityPlayer().func_184614_ca());
            Item item = event.getEntityPlayer().func_184614_ca().func_77973_b();
            if (capability != null && item.func_150897_b(event.getState())) {
                if (event.getState().func_177230_c() instanceof BlockLogTFC && !((Boolean)event.getState().func_177229_b((IProperty)BlockLogTFC.PLACED)).booleanValue()) {
                    return;
                }
                if (capability.getCharges() > 256) {
                    event.setNewSpeed(event.getNewSpeed() + (float)ConfigTFCThings.Items.WHETSTONE.bonusSpeed + 4.0f);
                } else if (capability.getCharges() > 64) {
                    event.setNewSpeed(event.getNewSpeed() + (float)ConfigTFCThings.Items.WHETSTONE.bonusSpeed + 2.0f);
                } else if (capability.getCharges() > 0) {
                    event.setNewSpeed(event.getNewSpeed() + (float)ConfigTFCThings.Items.WHETSTONE.bonusSpeed);
                }
            }
        }
    }

    @Nullable
    public static ISharpness getSharpnessCapability(ItemStack itemStack) {
        Object capability = itemStack.getCapability(CapabilitySharpness.SHARPNESS_CAPABILITY, null);
        if (capability instanceof ISharpness) {
            ISharpness sharpness = (ISharpness)capability;
            return sharpness;
        }
        return null;
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        if (event.getEntityItem().func_92059_d().func_77973_b() instanceof ItemRopeJavelin) {
            ItemRopeJavelin javelin = (ItemRopeJavelin)event.getEntityItem().func_92059_d().func_77973_b();
            javelin.retractJavelin(event.getEntityItem().func_92059_d(), event.getEntity().func_130014_f_());
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getItemStack().func_77973_b() instanceof ItemRopeJavelin && event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof BlockToolRack) {
            ((ItemRopeJavelin)event.getItemStack().func_77973_b()).retractJavelin(event.getItemStack(), event.getWorld());
        }
    }
}

