/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.entity.projectile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import lyeoj.tfcthings.items.ItemRopeJavelin;
import net.dries007.tfc.Constants;
import net.dries007.tfc.util.skills.SmithingSkill;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public class EntityThrownRopeJavelin
extends EntityArrow
implements IThrowableEntity,
IEntityAdditionalSpawnData {
    private ItemStack weapon = ItemStack.field_190927_a;
    private int knockbackStrength = 0;
    protected double effectiveRange = 1024.0;

    public EntityThrownRopeJavelin(World world) {
        super(world);
        this.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
    }

    public EntityThrownRopeJavelin(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
    }

    public EntityThrownRopeJavelin(World world, EntityLivingBase shooter) {
        super(world, shooter);
        this.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
    }

    public Entity getThrower() {
        return this.field_70250_c;
    }

    public void setThrower(Entity entity) {
        this.field_70250_c = entity;
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.weapon);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setWeapon(ByteBufUtils.readItemStack((ByteBuf)additionalData));
    }

    public ItemStack getWeapon() {
        return this.weapon;
    }

    public void setWeapon(ItemStack stack) {
        this.weapon = stack;
    }

    public void func_70071_h_() {
        if (this.getWeapon().func_77973_b() instanceof ItemRopeJavelin) {
            ItemRopeJavelin javelin = (ItemRopeJavelin)this.getWeapon().func_77973_b();
            if (this.getThrower() == null) {
                javelin.retractJavelin(this.getWeapon(), this.field_70170_p);
            }
            if (javelin.getCapturedEntity(this.getWeapon(), this.func_130014_f_()) != null) {
                this.func_189654_d(true);
                Entity caughtEntity = javelin.getCapturedEntity(this.getWeapon(), this.func_130014_f_());
                this.field_70165_t = caughtEntity.field_70165_t;
                double d2 = caughtEntity.field_70131_O;
                this.field_70163_u = caughtEntity.func_174813_aQ().field_72338_b + d2 * 0.8;
                this.field_70161_v = caughtEntity.field_70161_v;
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                return;
            }
            this.func_189654_d(false);
            this.performAdditionalUpdates();
        }
        if (this.shouldRetract(this.getWeapon(), this.field_70170_p)) {
            this.func_70030_z();
            return;
        }
        super.func_70071_h_();
    }

    protected void performAdditionalUpdates() {
    }

    protected void func_184549_a(@Nonnull RayTraceResult raytraceResultIn) {
        if (this.getWeapon().func_77973_b() instanceof ItemRopeJavelin) {
            ItemRopeJavelin javelin = (ItemRopeJavelin)this.getWeapon().func_77973_b();
            Entity entity = raytraceResultIn.field_72308_g;
            if (this.getThrower() instanceof EntityLivingBase && javelin.getCapturedEntity(this.getWeapon(), this.func_130014_f_()) == null) {
                EntityLivingBase thrower = (EntityLivingBase)this.getThrower();
                float skillModifier = SmithingSkill.getSkillBonus((ItemStack)this.getWeapon(), (SmithingSkill.Type)SmithingSkill.Type.WEAPONS) / 2.0f;
                int damageAmount = 1;
                if (skillModifier > 0.0f && Constants.RNG.nextFloat() < skillModifier) {
                    --damageAmount;
                }
                if (entity != null) {
                    ++damageAmount;
                }
                this.weapon.func_77972_a(damageAmount, thrower);
            }
            if (entity != null) {
                ItemStack weapon = this.getWeapon();
                float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                float finalDamage = f * (float)this.func_70242_d();
                if (this.func_70241_g()) {
                    finalDamage *= 2.0f;
                }
                DamageSource damagesource = this.field_70250_c == null ? DamageSource.func_76353_a((EntityArrow)this, (Entity)this) : DamageSource.func_76353_a((EntityArrow)this, (Entity)this.field_70250_c);
                if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
                    entity.func_70015_d(5);
                }
                if (javelin.getCapturedEntity(this.getWeapon(), this.func_130014_f_()) == null) {
                    if (entity.func_70097_a(damagesource, finalDamage)) {
                        javelin.setCapturedEntity(this.getWeapon(), entity);
                        if (entity instanceof EntityLivingBase) {
                            float f1;
                            EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                            if (this.knockbackStrength > 0 && (f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                                entitylivingbase.func_70024_g(this.field_70159_w * (double)this.knockbackStrength * (double)0.6f / (double)f1, 0.1, this.field_70179_y * (double)this.knockbackStrength * (double)0.6f / (double)f1);
                            }
                            this.func_184548_a(entitylivingbase);
                            if (this.field_70250_c != null && entitylivingbase != this.field_70250_c && entitylivingbase instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                            }
                        }
                        this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    } else {
                        this.field_70159_w *= (double)-0.1f;
                        this.field_70181_x *= (double)-0.1f;
                        this.field_70179_y *= (double)-0.1f;
                        this.field_70177_z += 180.0f;
                        this.field_70126_B += 180.0f;
                        if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < (double)0.001f) {
                            this.func_70106_y();
                        }
                    }
                }
            } else if (javelin.getCapturedEntity(this.getWeapon(), this.func_130014_f_()) == null) {
                super.func_184549_a(raytraceResultIn);
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        NBTTagList tag = new NBTTagList();
        tag.func_74742_a((NBTBase)this.weapon.serializeNBT());
        compound.func_74782_a("weapon", (NBTBase)tag);
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        NBTTagList tag = compound.func_150295_c("weapon", 10);
        this.weapon = tag.func_74745_c() > 0 ? new ItemStack(tag.func_150305_b(0)) : ItemStack.field_190927_a;
        super.func_70037_a(compound);
    }

    @Nonnull
    protected ItemStack func_184550_j() {
        return this.weapon;
    }

    public void func_70240_a(int knockbackStrength) {
        this.knockbackStrength = knockbackStrength;
    }

    private boolean shouldRetract(ItemStack stack, World world) {
        if (stack != null && stack.func_77973_b() instanceof ItemRopeJavelin) {
            ItemRopeJavelin javelin = (ItemRopeJavelin)this.getWeapon().func_77973_b();
            if (this.getThrower() instanceof EntityLivingBase) {
                EntityLivingBase thrower = (EntityLivingBase)this.getThrower();
                ItemStack itemstack = thrower.func_184614_ca();
                ItemStack itemstack1 = thrower.func_184592_cb();
                boolean flag = ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)this.getWeapon());
                boolean flag1 = ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)this.getWeapon());
                if (itemstack.func_77973_b() instanceof ItemRopeJavelin) {
                    flag1 = false;
                }
                if (thrower.func_70089_S() && (flag || flag1) && this.func_70068_e((Entity)thrower) <= this.effectiveRange) {
                    return false;
                }
                javelin.retractJavelin(stack, world);
                return true;
            }
            javelin.retractJavelin(stack, world);
            return true;
        }
        if (!world.field_72995_K) {
            this.func_70106_y();
        }
        return true;
    }
}

