/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.entity.projectile;

import javax.annotation.Nonnull;
import lyeoj.tfcthings.entity.projectile.EntityThrownRopeJavelin;
import lyeoj.tfcthings.items.ItemHookJavelin;
import lyeoj.tfcthings.main.TFCThings;
import lyeoj.tfcthings.network.MessageHookJavelinUpdate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityThrownHookJavelin
extends EntityThrownRopeJavelin {
    private static final DataParameter<Float> LENGTH = EntityDataManager.func_187226_a(EntityThrownHookJavelin.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final String LENGTH_NBT_KEY = "length";
    private boolean inGroundSynced = false;

    public EntityThrownHookJavelin(World world) {
        super(world);
    }

    public EntityThrownHookJavelin(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityThrownHookJavelin(World world, EntityLivingBase shooter) {
        super(world, shooter);
        this.effectiveRange = 4096.0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LENGTH, (Object)Float.valueOf(0.0f));
    }

    public void setLength(float length) {
        if (length < 1.0f) {
            this.func_184212_Q().func_187227_b(LENGTH, (Object)Float.valueOf(1.0f));
        } else if (length > 60.0f) {
            this.func_184212_Q().func_187227_b(LENGTH, (Object)Float.valueOf(60.0f));
        } else {
            this.func_184212_Q().func_187227_b(LENGTH, (Object)Float.valueOf(length));
        }
    }

    public float getLength() {
        return ((Float)this.func_184212_Q().func_187225_a(LENGTH)).floatValue();
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a(LENGTH_NBT_KEY, this.getLength());
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b(LENGTH_NBT_KEY, 99)) {
            this.setLength(compound.func_74760_g(LENGTH_NBT_KEY));
        }
        super.func_70037_a(compound);
    }

    public void setInGroundSynced(boolean inGroundSynced) {
        this.inGroundSynced = inGroundSynced;
    }

    @Override
    protected void performAdditionalUpdates() {
        if (this.getWeapon().func_77973_b() instanceof ItemHookJavelin && this.getThrower() != null) {
            EntityLivingBase thrower = (EntityLivingBase)this.getThrower();
            float length = this.getLength();
            if (!this.field_70170_p.field_72995_K && this.inGroundSynced != this.field_70254_i) {
                this.inGroundSynced = this.field_70254_i;
                TFCThings.network.sendTo((IMessage)new MessageHookJavelinUpdate(this.func_145782_y(), this.inGroundSynced), (EntityPlayerMP)thrower);
            }
            if (thrower != null && (this.field_70254_i || this.inGroundSynced) && this.field_70163_u > thrower.field_70163_u && this.func_70032_d((Entity)thrower) > length && !thrower.field_70122_E) {
                thrower.field_70143_R = 0.0f;
                Vec3d rope = thrower.func_174791_d().func_178788_d(this.func_174791_d()).func_72432_b();
                Vec3d velocity = new Vec3d(thrower.field_70159_w, thrower.field_70181_x, thrower.field_70179_y);
                Vec3d motion = velocity.func_72432_b().func_178788_d(rope);
                double speed = velocity.func_72433_c();
                thrower.field_70159_w = motion.field_72450_a * speed;
                if (Math.abs(thrower.field_70159_w) > 1.4) {
                    thrower.field_70159_w = thrower.field_70159_w > 0.0 ? 1.4 : -1.4;
                }
                thrower.field_70181_x = motion.field_72448_b * speed;
                if (thrower.field_70181_x > 1.0) {
                    thrower.field_70181_x = 1.0;
                }
                thrower.field_70179_y = motion.field_72449_c * speed;
                if (Math.abs(thrower.field_70179_y) > 1.4) {
                    double d = thrower.field_70179_y = thrower.field_70179_y > 0.0 ? 1.4 : -1.4;
                }
                if (speed < 0.09 && (double)this.func_70032_d((Entity)thrower) > (double)length + 0.3) {
                    thrower.field_70181_x = 0.1;
                }
            } else if (thrower != null && thrower.field_70122_E && this.func_70032_d((Entity)thrower) > length) {
                this.setLength(this.func_70032_d((Entity)thrower));
            }
            if (thrower != null && thrower.func_70093_af()) {
                this.setLength(this.getLength() + 0.2f);
            }
        }
    }

    @Override
    protected void func_184549_a(@Nonnull RayTraceResult raytraceResultIn) {
        super.func_184549_a(raytraceResultIn);
        if (this.getWeapon().func_77973_b() instanceof ItemHookJavelin) {
            EntityLivingBase thrower = (EntityLivingBase)this.getThrower();
            this.setLength(this.func_70032_d((Entity)thrower));
        }
    }
}

