/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.entity.projectile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import lyeoj.tfcthings.blocks.BlockRopeBridge;
import lyeoj.tfcthings.init.TFCThingsBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class EntityRopeBridgeThrown
extends EntityThrowable {
    private ItemStack bridges;

    public EntityRopeBridgeThrown(World worldIn) {
        super(worldIn);
        this.bridges = ItemStack.field_190927_a;
    }

    public EntityRopeBridgeThrown(World worldIn, EntityLivingBase throwerIn, ItemStack bridges) {
        super(worldIn, throwerIn);
        this.bridges = bridges;
    }

    public ItemStack getBridges() {
        return this.bridges;
    }

    public void setBridges(ItemStack bridges) {
        this.bridges = bridges;
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.bridges);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setBridges(ByteBufUtils.readItemStack((ByteBuf)additionalData));
    }

    public void func_70014_b(NBTTagCompound compound) {
        NBTTagList tag = new NBTTagList();
        tag.func_74742_a((NBTBase)this.bridges.serializeNBT());
        compound.func_74782_a("bridges", (NBTBase)tag);
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        NBTTagList tag = compound.func_150295_c("bridges", 10);
        this.bridges = tag.func_74745_c() > 0 ? new ItemStack(tag.func_150305_b(0)) : ItemStack.field_190927_a;
        super.func_70037_a(compound);
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result.func_178782_a() == null) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)3);
                this.func_70106_y();
                return;
            }
            if (result.func_178782_a() != null && this.field_70170_p.func_180495_p(result.func_178782_a()).func_185890_d((IBlockAccess)this.field_70170_p, result.func_178782_a()) != Block.field_185506_k) {
                if (this.func_85052_h() != null) {
                    BlockPos end = result.func_178782_a().func_177984_a();
                    BlockPos start = this.func_85052_h().func_180425_c();
                    int xDif = end.func_177958_n() - start.func_177958_n();
                    int zDif = end.func_177952_p() - start.func_177952_p();
                    boolean axis = Math.abs(zDif) > Math.abs(xDif);
                    int length = axis ? Math.abs(zDif) : Math.abs(xDif);
                    boolean diagonal = false;
                    int yDif = start.func_177956_o() - end.func_177956_o();
                    if (length - 1 > this.bridges.func_190916_E()) {
                        this.func_85052_h().func_145747_a((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.rope_bridge_too_long", new Object[0]));
                    } else if ((length - 2) / 8 < Math.abs(yDif)) {
                        this.func_85052_h().func_145747_a((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.rope_bridge_too_steep", new Object[0]));
                    } else {
                        BlockPos tempEnd;
                        if (axis) {
                            if (Math.abs(xDif) < 3) {
                                tempEnd = new BlockPos(start.func_177958_n(), end.func_177956_o(), end.func_177952_p());
                                if (this.shouldReplaceBlock(tempEnd.func_177977_b(), this.field_70170_p)) {
                                    BlockPos tempStart = new BlockPos(end.func_177958_n(), start.func_177956_o(), start.func_177952_p());
                                    if (this.shouldReplaceBlock(tempStart.func_177977_b(), this.field_70170_p)) {
                                        this.func_85052_h().func_145747_a((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.rope_bridge_bad_connection", new Object[0]));
                                        diagonal = true;
                                    } else {
                                        start = tempStart;
                                    }
                                } else {
                                    end = tempEnd;
                                }
                            } else {
                                this.func_85052_h().func_145747_a((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.rope_bridge_diagonal", new Object[0]));
                                diagonal = true;
                            }
                        } else if (Math.abs(zDif) < 3) {
                            tempEnd = new BlockPos(end.func_177958_n(), end.func_177956_o(), start.func_177952_p());
                            if (this.shouldReplaceBlock(tempEnd.func_177977_b(), this.field_70170_p)) {
                                BlockPos tempStart = new BlockPos(start.func_177958_n(), start.func_177956_o(), end.func_177952_p());
                                if (this.shouldReplaceBlock(tempStart.func_177977_b(), this.field_70170_p)) {
                                    this.func_85052_h().func_145747_a((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.rope_bridge_bad_connection", new Object[0]));
                                    diagonal = true;
                                } else {
                                    start = tempStart;
                                }
                            } else {
                                end = tempEnd;
                            }
                        } else {
                            this.func_85052_h().func_145747_a((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.rope_bridge_diagonal", new Object[0]));
                            diagonal = true;
                        }
                        EnumFacing direction = axis ? (zDif > 0 ? EnumFacing.SOUTH : EnumFacing.NORTH) : (xDif > 0 ? EnumFacing.EAST : EnumFacing.WEST);
                        switch (direction) {
                            case SOUTH: {
                                start = start.func_177968_d();
                                end = end.func_177978_c();
                                break;
                            }
                            case NORTH: {
                                start = start.func_177978_c();
                                end = end.func_177968_d();
                                break;
                            }
                            case EAST: {
                                start = start.func_177974_f();
                                end = end.func_177976_e();
                                break;
                            }
                            default: {
                                start = start.func_177976_e();
                                end = end.func_177974_f();
                            }
                        }
                        if (!diagonal) {
                            this.buildBridge(start, end, axis, direction, yDif, length);
                        }
                    }
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)3);
                this.func_70106_y();
            }
        }
    }

    private void buildBridge(BlockPos start, BlockPos end, boolean axis, EnumFacing direction, int yDif, int length) {
        ArrayList<BridgeInfo> bridgePath = new ArrayList<BridgeInfo>();
        int startHeight = 0;
        int endHeight = 0;
        int startDif = yDif > 0 ? yDif + 1 : 1;
        int endDif = yDif < 0 ? Math.abs(yDif) + 1 : 1;
        int remainingPieces = length;
        while (remainingPieces > 1) {
            if (startDif == endDif) {
                if (this.shouldReplaceBlock(start, this.field_70170_p)) {
                    bridgePath.add(new BridgeInfo(start, startHeight));
                    start = this.moveInDirection(direction, start, false);
                    if (startHeight == 0) {
                        if (startDif > 0 && this.shouldReplaceBlock(start.func_177977_b(), this.field_70170_p)) {
                            startHeight = 7;
                            start = start.func_177977_b();
                            --startDif;
                        } else if (startHeight < endHeight && endHeight - startHeight >= remainingPieces / 2) {
                            ++startHeight;
                        }
                    } else if (startHeight < endHeight) {
                        if (endHeight - startHeight >= remainingPieces / 2) {
                            ++startHeight;
                        }
                    } else {
                        --startHeight;
                    }
                } else {
                    this.func_85052_h().func_145747_a((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.rope_bridge_interrupted", new Object[0]));
                    return;
                }
                if (--remainingPieces <= 0) continue;
                if (this.shouldReplaceBlock(end, this.field_70170_p)) {
                    if (remainingPieces == 1 && endHeight < 7) {
                        ++endHeight;
                    }
                    bridgePath.add(new BridgeInfo(end, endHeight));
                    end = this.moveInDirection(direction, end, true);
                    if (endHeight == 0) {
                        if (endDif > 0 && this.shouldReplaceBlock(end.func_177977_b(), this.field_70170_p)) {
                            endHeight = 7;
                            end = end.func_177977_b();
                            --endDif;
                        } else if (endHeight < startHeight && startHeight - endHeight >= remainingPieces / 2) {
                            ++endHeight;
                        }
                    } else if (endHeight < startHeight) {
                        if (startHeight - endHeight >= remainingPieces / 2) {
                            ++endHeight;
                        }
                    } else {
                        --endHeight;
                    }
                    --remainingPieces;
                    continue;
                }
                this.func_85052_h().func_145747_a((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.rope_bridge_interrupted", new Object[0]));
                return;
            }
            if (startDif > endDif) {
                if (this.shouldReplaceBlock(start, this.field_70170_p)) {
                    bridgePath.add(new BridgeInfo(start, startHeight));
                    start = this.moveInDirection(direction, start, false);
                    if (startHeight == 0) {
                        if (startDif > 0 && this.shouldReplaceBlock(start.func_177977_b(), this.field_70170_p)) {
                            startHeight = 7;
                            start = start.func_177977_b();
                            --startDif;
                        } else if ((remainingPieces - 1) / 8 < startDif - 1) {
                            this.func_85052_h().func_145747_a((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.rope_bridge_too_steep", new Object[0]));
                            return;
                        }
                    } else {
                        --startHeight;
                    }
                    --remainingPieces;
                    continue;
                }
                this.func_85052_h().func_145747_a((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.rope_bridge_interrupted", new Object[0]));
                return;
            }
            if (this.shouldReplaceBlock(end, this.field_70170_p)) {
                bridgePath.add(new BridgeInfo(end, endHeight));
                end = this.moveInDirection(direction, end, true);
                if (endHeight == 0) {
                    if (endDif > 0 && this.shouldReplaceBlock(end.func_177977_b(), this.field_70170_p)) {
                        endHeight = 7;
                        end = end.func_177977_b();
                        --endDif;
                    } else if ((remainingPieces - 1) / 8 < endDif - 1) {
                        this.func_85052_h().func_145747_a((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.rope_bridge_too_steep", new Object[0]));
                        return;
                    }
                } else {
                    --endHeight;
                }
                --remainingPieces;
                continue;
            }
            this.func_85052_h().func_145747_a((ITextComponent)new TextComponentTranslation("tfcthings.tooltip.rope_bridge_interrupted", new Object[0]));
            return;
        }
        for (BridgeInfo info : bridgePath) {
            this.field_70170_p.func_175656_a(info.pos, TFCThingsBlocks.ROPE_BRIDGE_BLOCK.func_176223_P().func_177226_a((IProperty)BlockRopeBridge.AXIS, (Comparable)Boolean.valueOf(axis)).func_177226_a((IProperty)BlockRopeBridge.OFFSET, (Comparable)Integer.valueOf(info.height)));
        }
        if (this.func_85052_h() instanceof EntityPlayer && !((EntityPlayer)this.func_85052_h()).func_184812_l_()) {
            this.bridges.func_190920_e(this.bridges.func_190916_E() - (length - 1));
        }
    }

    private BlockPos moveInDirection(EnumFacing direction, BlockPos pos, boolean flip) {
        BlockPos value;
        switch (direction) {
            case SOUTH: {
                if (flip) {
                    value = pos.func_177978_c();
                    break;
                }
                value = pos.func_177968_d();
                break;
            }
            case NORTH: {
                if (flip) {
                    value = pos.func_177968_d();
                    break;
                }
                value = pos.func_177978_c();
                break;
            }
            case EAST: {
                if (flip) {
                    value = pos.func_177976_e();
                    break;
                }
                value = pos.func_177974_f();
                break;
            }
            default: {
                value = flip ? pos.func_177974_f() : pos.func_177976_e();
            }
        }
        return value;
    }

    private boolean shouldReplaceBlock(BlockPos pos, World world) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Material material = iblockstate.func_185904_a();
        if (material == Material.field_151587_i || material == Material.field_151586_h) {
            return false;
        }
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
    }

    private static class BridgeInfo {
        public BlockPos pos;
        public int height;
        public boolean axis;

        public BridgeInfo(BlockPos pos, int height) {
            this.pos = pos;
            this.height = height;
        }
    }
}

