/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lyeoj.tfcthings.capability.CapabilitySharpness;
import lyeoj.tfcthings.capability.ISharpness;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class SharpnessHandler
implements ISharpness {
    protected ItemStack container;
    public static final String SHARPNESS_NBT_KEY = "Sharpness";

    public SharpnessHandler(ItemStack container) {
        this.container = container;
    }

    public SharpnessHandler() {
        this.container = null;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    @Override
    public int getCharges() {
        NBTTagCompound tag = this.container.func_77978_p();
        if (tag != null && tag.func_74764_b(SHARPNESS_NBT_KEY)) {
            return tag.func_74762_e(SHARPNESS_NBT_KEY);
        }
        return 0;
    }

    @Override
    public void setCharges(int charges) {
        if (!this.container.func_77942_o()) {
            this.container.func_77982_d(new NBTTagCompound());
        }
        this.container.func_77978_p().func_74768_a(SHARPNESS_NBT_KEY, charges);
    }

    @Override
    public void addCharge() {
        this.setCharges(this.getCharges() + 1);
    }

    @Override
    public void removeCharge() {
        if (this.getCharges() > 0) {
            this.setCharges(this.getCharges() - 1);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilitySharpness.SHARPNESS_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilitySharpness.SHARPNESS_CAPABILITY ? this : null);
    }
}

