/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lyeoj.tfcthings.items.TFCThingsConfigurableItem;
import lyeoj.tfcthings.main.ConfigTFCThings;
import lyeoj.tfcthings.tileentity.TileEntityBearTrap;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.objects.CreativeTabsTFC;
import net.dries007.tfc.objects.entity.animal.AnimalFood;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.objects.entity.animal.EntityChickenTFC;
import net.dries007.tfc.objects.entity.animal.EntityDuckTFC;
import net.dries007.tfc.objects.entity.animal.EntityGrouseTFC;
import net.dries007.tfc.objects.entity.animal.EntityHareTFC;
import net.dries007.tfc.objects.entity.animal.EntityPheasantTFC;
import net.dries007.tfc.objects.entity.animal.EntityQuailTFC;
import net.dries007.tfc.objects.entity.animal.EntityRabbitTFC;
import net.dries007.tfc.objects.entity.animal.EntityTurkeyTFC;
import net.dries007.tfc.objects.items.ItemSeedsTFC;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSnare
extends Block
implements IItemSize,
TFCThingsConfigurableItem {
    protected static final AxisAlignedBB TRAP_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0);
    public static final PropertyBool CLOSED = PropertyBool.func_177716_a((String)"closed");
    public static final PropertyBool BAITED = PropertyBool.func_177716_a((String)"baited");
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockSnare() {
        super(Material.field_151575_d);
        this.func_149663_c("snare");
        this.setRegistryName("snare");
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(CreativeTabsTFC.CT_MISC);
        this.func_149711_c(1.5f);
        this.setHarvestLevel("axe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BAITED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CLOSED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntityBearTrap createTileEntity(World world, IBlockState state) {
        return new TileEntityBearTrap();
    }

    public TileEntityBearTrap getTileEntity(IBlockAccess world, BlockPos pos) {
        return (TileEntityBearTrap)world.func_175625_s(pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, BAITED, CLOSED});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a((IProperty)BAITED, (Comparable)Boolean.valueOf(meta / 4 % 2 != 0)).func_177226_a((IProperty)CLOSED, (Comparable)Boolean.valueOf(meta / 8 != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)BAITED) != false ? 4 : 0) + ((Boolean)state.func_177229_b((IProperty)CLOSED) != false ? 8 : 0);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        AxisAlignedBB axisalignedbb = blockState.func_185900_c(worldIn, pos);
        return new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, 0.0, axisalignedbb.field_72334_f);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
        Block block = iblockstate.func_177230_c();
        if (block != Blocks.field_180401_cv) {
            BlockFaceShape blockfaceshape = iblockstate.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
            return blockfaceshape == BlockFaceShape.SOLID || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, pos.func_177977_b());
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        TileEntityBearTrap trap = (TileEntityBearTrap)te;
        if (!trap.isOpen()) {
            if (Math.random() < ConfigTFCThings.Items.SNARE.breakChance) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 1.0f, 0.8f);
            } else {
                super.func_180657_a(worldIn, player, pos, state, te, stack);
            }
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        if (!((Boolean)state.func_177229_b((IProperty)BAITED)).booleanValue() && ((stack = playerIn.func_184586_b(hand)).func_77973_b() instanceof ItemSeedsTFC || this.isFood(stack)) && !worldIn.field_72995_K) {
            if (!playerIn.func_184812_l_()) {
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    playerIn.field_71071_by.func_184437_d(stack);
                }
            }
            state = state.func_177226_a((IProperty)BAITED, (Comparable)Boolean.valueOf(true));
            worldIn.func_180501_a(pos, state, 2);
        }
        return true;
    }

    private boolean isFood(ItemStack stack) {
        AnimalFood food = AnimalFood.get(EntityChickenTFC.class);
        return food != null && food.isFood(stack);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (this.isCapturable(entityIn)) {
            TileEntityBearTrap trap = this.getTileEntity((IBlockAccess)worldIn, pos);
            EntityLivingBase entityLiving = (EntityLivingBase)entityIn;
            if (trap.isOpen()) {
                trap.setCapturedEntity(entityLiving);
                entityIn.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                trap.setOpen(false);
                state = state.func_177226_a((IProperty)CLOSED, (Comparable)Boolean.valueOf(true));
                state = state.func_177226_a((IProperty)BAITED, (Comparable)Boolean.valueOf(false));
                worldIn.func_180501_a(pos, state, 2);
            } else if (trap.getCapturedEntity() != null && trap.getCapturedEntity().equals((Object)entityLiving)) {
                entityLiving.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        AxisAlignedBB captureBox = new AxisAlignedBB((double)pos.func_177958_n() - 10.0, (double)pos.func_177956_o() - 5.0, (double)pos.func_177952_p() - 10.0, (double)pos.func_177958_n() + 10.0, (double)pos.func_177956_o() + 5.0, (double)pos.func_177952_p() + 10.0);
        TileEntityBearTrap snare = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (snare.isOpen() && worldIn.func_72872_a(EntityPlayer.class, captureBox).isEmpty() && !worldIn.field_72995_K) {
            for (EntityAnimalTFC animal : worldIn.func_72872_a(EntityAnimalTFC.class, captureBox)) {
                if (!this.isCapturable((Entity)animal) || worldIn.func_180495_p(animal.func_180425_c()).func_177230_c() instanceof BlockSnare) continue;
                snare.setCapturedEntity((EntityLivingBase)animal);
                snare.setOpen(false);
                state = state.func_177226_a((IProperty)CLOSED, (Comparable)Boolean.valueOf(true));
                state = state.func_177226_a((IProperty)BAITED, (Comparable)Boolean.valueOf(false));
                worldIn.func_180501_a(pos, state, 2);
                animal.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                return;
            }
            if (((Boolean)state.func_177229_b((IProperty)BAITED)).booleanValue()) {
                if (rand.nextDouble() < ConfigTFCThings.Items.SNARE.baitCaptureChance) {
                    double entitySelection = rand.nextDouble();
                    Object animal = entitySelection < 0.1 ? (entitySelection < 0.03 ? (entitySelection < 0.01 ? new EntityGrouseTFC(worldIn) : new EntityQuailTFC(worldIn)) : new EntityDuckTFC(worldIn)) : (entitySelection < 0.5 ? (entitySelection < 0.3 ? new EntityHareTFC(worldIn) : new EntityRabbitTFC(worldIn)) : new EntityPheasantTFC(worldIn));
                    animal.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                    worldIn.func_72838_d((Entity)animal);
                    snare.setCapturedEntity((EntityLivingBase)animal);
                    snare.setOpen(false);
                    state = state.func_177226_a((IProperty)CLOSED, (Comparable)Boolean.valueOf(true));
                    state = state.func_177226_a((IProperty)BAITED, (Comparable)Boolean.valueOf(false));
                    worldIn.func_180501_a(pos, state, 2);
                } else if (rand.nextDouble() < ConfigTFCThings.Items.SNARE.baitExpireChance) {
                    state = state.func_177226_a((IProperty)BAITED, (Comparable)Boolean.valueOf(false));
                    worldIn.func_180501_a(pos, state, 2);
                }
            }
        }
    }

    private boolean isCapturable(Entity entityIn) {
        return entityIn instanceof EntityRabbitTFC || entityIn instanceof EntityPheasantTFC || entityIn instanceof EntityDuckTFC || entityIn instanceof EntityChickenTFC || entityIn instanceof EntityTurkeyTFC;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP)) {
            TileEntityBearTrap trap = this.getTileEntity((IBlockAccess)worldIn, pos);
            if (!trap.isOpen()) {
                if (Math.random() < ConfigTFCThings.Items.SNARE.breakChance) {
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 1.0f, 0.8f);
                } else {
                    this.func_176226_b(worldIn, pos, state, 0);
                }
            } else {
                this.func_176226_b(worldIn, pos, state, 0);
            }
            worldIn.func_175698_g(pos);
        }
    }

    @Nonnull
    public Size getSize(@Nonnull ItemStack itemStack) {
        return Size.LARGE;
    }

    @Nonnull
    public Weight getWeight(@Nonnull ItemStack itemStack) {
        return Weight.MEDIUM;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return TRAP_AABB;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean isEnabled() {
        return ConfigTFCThings.Items.MASTER_ITEM_LIST.enableSnare;
    }
}

