/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.blocks;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import lyeoj.tfcthings.init.TFCThingsItems;
import lyeoj.tfcthings.items.TFCThingsConfigurableItem;
import lyeoj.tfcthings.main.ConfigTFCThings;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRopeBridge
extends Block
implements TFCThingsConfigurableItem {
    public static final PropertyInteger OFFSET = PropertyInteger.func_177719_a((String)"offset", (int)0, (int)7);
    public static final PropertyBool AXIS = PropertyBool.func_177716_a((String)"axis");

    public BlockRopeBridge() {
        super(Material.field_151575_d);
        this.func_149663_c("rope_bridge");
        this.setRegistryName("rope_bridge");
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(0.5f);
        this.setHarvestLevel("axe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)OFFSET, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)AXIS, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        int i = (Integer)blockState.func_177229_b((IProperty)OFFSET);
        return new AxisAlignedBB(0.0, (double)((float)i * 0.125f), 0.0, 1.0, (double)((float)i * 0.125f + 0.1875f), 1.0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{OFFSET, AXIS});
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return TFCThingsItems.ITEM_ROPE_BRIDGE;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)OFFSET, (Comparable)Integer.valueOf(meta % 8)).func_177226_a((IProperty)AXIS, (Comparable)Boolean.valueOf(meta > 7));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)OFFSET) + ((Boolean)state.func_177229_b((IProperty)AXIS) != false ? 8 : 0);
    }

    @Override
    public boolean isEnabled() {
        return ConfigTFCThings.Items.MASTER_ITEM_LIST.enableRopeBridge;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (OreDictionaryHelper.doesStackMatchOre((ItemStack)playerIn.func_184586_b(hand), (String)"stickWood")) {
            state = state.func_177231_a((IProperty)OFFSET);
            worldIn.func_180501_a(pos, state, 2);
            return true;
        }
        if (playerIn.func_70093_af()) {
            int dir = this.getDir(worldIn, pos, state);
            if (dir == 0) {
                return false;
            }
            ItemStack bridgeStack = new ItemStack(TFCThingsItems.ITEM_ROPE_BRIDGE, 0);
            BlockPos next = pos;
            while (worldIn.func_180495_p(next).func_177230_c() instanceof BlockRopeBridge) {
                bridgeStack.func_190917_f(1);
                if (worldIn.func_180495_p(this.moveInDirection(next, dir)).func_177230_c() instanceof BlockRopeBridge) {
                    worldIn.func_175698_g(next);
                    next = this.moveInDirection(next, dir);
                    continue;
                }
                if ((Integer)worldIn.func_180495_p(next).func_177229_b((IProperty)OFFSET) == 0) {
                    worldIn.func_175698_g(next);
                    next = this.moveInDirection(next, dir).func_177977_b();
                    continue;
                }
                if ((Integer)worldIn.func_180495_p(next).func_177229_b((IProperty)OFFSET) != 7) continue;
                worldIn.func_175698_g(next);
                next = this.moveInDirection(next, dir).func_177984_a();
            }
            playerIn.field_71071_by.func_70441_a(bridgeStack);
            return true;
        }
        return false;
    }

    private BlockPos moveInDirection(BlockPos pos, int dir) {
        switch (dir) {
            case 1: {
                return pos.func_177978_c();
            }
            case 2: {
                return pos.func_177968_d();
            }
            case 3: {
                return pos.func_177974_f();
            }
        }
        return pos.func_177976_e();
    }

    private int getDir(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos side2;
        BlockPos side1;
        ArrayList<Integer> dirs = new ArrayList<Integer>();
        if (((Boolean)state.func_177229_b((IProperty)AXIS)).booleanValue()) {
            side1 = pos.func_177978_c();
            side2 = pos.func_177968_d();
        } else {
            side1 = pos.func_177974_f();
            side2 = pos.func_177976_e();
        }
        if (worldIn.func_180495_p(side1).func_177230_c() instanceof BlockRopeBridge) {
            dirs.add(1);
        }
        if (worldIn.func_180495_p(side2).func_177230_c() instanceof BlockRopeBridge) {
            dirs.add(2);
        }
        if ((Integer)state.func_177229_b((IProperty)OFFSET) == 0) {
            if (worldIn.func_180495_p(side1.func_177977_b()).func_177230_c() instanceof BlockRopeBridge) {
                dirs.add(1);
            }
            if (worldIn.func_180495_p(side2.func_177977_b()).func_177230_c() instanceof BlockRopeBridge) {
                dirs.add(2);
            }
        }
        if ((Integer)state.func_177229_b((IProperty)OFFSET) == 7) {
            if (worldIn.func_180495_p(side1.func_177984_a()).func_177230_c() instanceof BlockRopeBridge) {
                dirs.add(1);
            }
            if (worldIn.func_180495_p(side2.func_177984_a()).func_177230_c() instanceof BlockRopeBridge) {
                dirs.add(2);
            }
        }
        if (dirs.size() == 1) {
            return (Integer)dirs.get(0) + ((Boolean)state.func_177229_b((IProperty)AXIS) != false ? 0 : 2);
        }
        return 0;
    }
}

