/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lyeoj.tfcthings.items.TFCThingsConfigurableItem;
import lyeoj.tfcthings.main.ConfigTFCThings;
import lyeoj.tfcthings.tileentity.TileEntityGemDisplay;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGemDisplay
extends Block
implements IItemSize,
TFCThingsConfigurableItem {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");

    public BlockGemDisplay(String rock) {
        super(Material.field_151576_e);
        this.setRegistryName("gem_display/" + rock);
        this.func_149663_c("gem_display_" + rock);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)));
    }

    @Nonnull
    public Size getSize(@Nonnull ItemStack itemStack) {
        return Size.LARGE;
    }

    @Nonnull
    public Weight getWeight(@Nonnull ItemStack itemStack) {
        return Weight.HEAVY;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TOP});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(meta / 4 % 2 != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)TOP) != false ? 4 : 0);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityGemDisplay();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityGemDisplay te;
        if (!worldIn.field_72995_K && (te = (TileEntityGemDisplay)Helpers.getTE((IBlockAccess)worldIn, (BlockPos)pos, TileEntityGemDisplay.class)) != null) {
            return te.onRightClick(playerIn, hand);
        }
        return true;
    }

    public void func_180663_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntityGemDisplay te = (TileEntityGemDisplay)Helpers.getTE((IBlockAccess)worldIn, (BlockPos)pos, TileEntityGemDisplay.class);
        if (te != null) {
            te.onBreakBlock();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (fromPos.equals((Object)pos.func_177984_a())) {
            state = worldIn.func_180495_p(fromPos).func_177230_c() instanceof BlockAir ? state.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)) : state.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false));
            worldIn.func_180501_a(pos, state, 2);
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityGemDisplay te = (TileEntityGemDisplay)world.func_175625_s(pos);
        return (int)Math.floor(15.0 * ((double)te.getSize() / (double)te.getMaxStackSize()));
    }

    @Override
    public boolean isEnabled() {
        return ConfigTFCThings.Items.MASTER_ITEM_LIST.enableGemDisplays;
    }
}

