/*
 * Decompiled with CFR 0.152.
 */
package lyeoj.tfcthings.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lyeoj.tfcthings.items.TFCThingsConfigurableItem;
import lyeoj.tfcthings.main.ConfigTFCThings;
import lyeoj.tfcthings.tileentity.TileEntityBearTrap;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.IPredator;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.CreativeTabsTFC;
import net.dries007.tfc.objects.items.metal.ItemMetalTool;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBearTrap
extends Block
implements IItemSize,
TFCThingsConfigurableItem {
    protected static final AxisAlignedBB TRAP_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0);
    public static final PropertyBool CLOSED = PropertyBool.func_177716_a((String)"closed");
    public static final PropertyBool BURIED = PropertyBool.func_177716_a((String)"buried");
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockBearTrap() {
        super(Material.field_151573_f);
        this.func_149663_c("bear_trap");
        this.setRegistryName("bear_trap");
        this.func_149647_a(CreativeTabsTFC.CT_METAL);
        this.func_149711_c(10.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BURIED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CLOSED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntityBearTrap createTileEntity(World world, IBlockState state) {
        return new TileEntityBearTrap();
    }

    public TileEntityBearTrap getTileEntity(IBlockAccess world, BlockPos pos) {
        return (TileEntityBearTrap)world.func_175625_s(pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return TRAP_AABB;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, BURIED, CLOSED});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a((IProperty)BURIED, (Comparable)Boolean.valueOf(meta / 4 % 2 != 0)).func_177226_a((IProperty)CLOSED, (Comparable)Boolean.valueOf(meta / 8 != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)BURIED) != false ? 4 : 0) + ((Boolean)state.func_177229_b((IProperty)CLOSED) != false ? 8 : 0);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        AxisAlignedBB axisalignedbb = blockState.func_185900_c(worldIn, pos);
        return new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, 0.0, axisalignedbb.field_72334_f);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
        Block block = iblockstate.func_177230_c();
        if (block != Blocks.field_180401_cv) {
            BlockFaceShape blockfaceshape = iblockstate.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
            return blockfaceshape == BlockFaceShape.SOLID || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, pos.func_177977_b());
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        TileEntityBearTrap trap = (TileEntityBearTrap)te;
        if (!trap.isOpen()) {
            if (Math.random() < ConfigTFCThings.Items.BEAR_TRAP.breakChance) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 1.0f, 0.8f);
            } else {
                super.func_180657_a(worldIn, player, pos, state, te, stack);
            }
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_184586_b(hand).func_77973_b() instanceof ItemSpade || playerIn.func_184586_b(hand).func_77973_b() instanceof ItemMetalTool && ((ItemMetalTool)playerIn.func_184586_b(hand).func_77973_b()).getType().equals((Object)Metal.ItemType.SHOVEL)) {
            playerIn.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)playerIn);
            state = state.func_177231_a((IProperty)BURIED);
            worldIn.func_180501_a(pos, state, 2);
            worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            TileEntityBearTrap trap = this.getTileEntity((IBlockAccess)worldIn, pos);
            EntityLivingBase entityLiving = (EntityLivingBase)entityIn;
            if (trap.isOpen()) {
                int debuffDuration = ConfigTFCThings.Items.BEAR_TRAP.debuffDuration;
                double healthCut = ConfigTFCThings.Items.BEAR_TRAP.healthCut;
                entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76421_d, debuffDuration));
                entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76419_f, debuffDuration));
                entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76437_t, debuffDuration));
                if (healthCut > 0.0) {
                    entityLiving.func_70097_a(DamageSource.field_76367_g, entityLiving.func_110143_aJ() / (float)healthCut);
                }
                trap.setCapturedEntity(entityLiving);
                entityIn.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                trap.setOpen(false);
                state = state.func_177226_a((IProperty)CLOSED, (Comparable)Boolean.valueOf(true));
                worldIn.func_180501_a(pos, state, 2);
                entityLiving.func_184185_a(SoundEvents.field_187635_cQ, 2.0f, 0.4f);
            } else if (trap.getCapturedEntity() != null && trap.getCapturedEntity().equals((Object)entityLiving)) {
                entityLiving.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                if (entityLiving instanceof IPredator && Math.random() < ConfigTFCThings.Items.BEAR_TRAP.breakoutChance) {
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 1.0f, 0.8f);
                    if (Math.random() > 2.0 * ConfigTFCThings.Items.BEAR_TRAP.breakChance) {
                        this.func_176226_b(worldIn, pos, state, 0);
                    }
                    worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), worldIn.field_72995_K ? 11 : 3);
                }
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP)) {
            TileEntityBearTrap trap = this.getTileEntity((IBlockAccess)worldIn, pos);
            if (!trap.isOpen()) {
                if (Math.random() < ConfigTFCThings.Items.BEAR_TRAP.breakChance) {
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 1.0f, 0.8f);
                } else {
                    this.func_176226_b(worldIn, pos, state, 0);
                }
            } else {
                this.func_176226_b(worldIn, pos, state, 0);
            }
            worldIn.func_175698_g(pos);
        }
    }

    @Nonnull
    public Size getSize(@Nonnull ItemStack itemStack) {
        return Size.LARGE;
    }

    @Nonnull
    public Weight getWeight(@Nonnull ItemStack itemStack) {
        return Weight.HEAVY;
    }

    @Override
    public boolean isEnabled() {
        return ConfigTFCThings.Items.MASTER_ITEM_LIST.enableBearTrap;
    }
}

