/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.sprayer;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import xyz.przemyk.simpleplanes.entities.HelicopterEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.sprayer.LargeSprayerModel;
import xyz.przemyk.simpleplanes.upgrades.sprayer.SprayerModel;

public class SprayerUpgrade
extends Upgrade {
    public static final ResourceLocation TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/sprayer.png");
    public static final AxisAlignedBB AFFECT_ENTITIES = new AxisAlignedBB(-3.0, -3.0, -3.0, 3.0, 0.0, 3.0);
    private int fluid = 0;
    private Potion effect = null;

    public SprayerUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.SPRAYER, planeEntity);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compoundNBT = new NBTTagCompound();
        compoundNBT.func_74768_a("fluid", this.fluid);
        String value = this.effect == null ? "empty" : this.effect.getRegistryName().toString();
        compoundNBT.func_74778_a("effect", value);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compoundNBT) {
        this.fluid = compoundNBT.func_74762_e("fluid");
        String effectName = compoundNBT.func_74779_i("effect");
        this.effect = effectName.equals("empty") ? null : (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effectName));
    }

    @Override
    public NBTTagCompound serializeNBTData() {
        return this.serializeNBT();
    }

    @Override
    public void deserializeNBTData(NBTTagCompound nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public boolean tick() {
        if (this.fluid > 0) {
            --this.fluid;
            if (this.planeEntity.field_70170_p.field_72995_K && this.effect != null) {
                int l1 = this.effect.func_76401_j();
                int i2 = l1 >> 16 & 0xFF;
                int j2 = l1 >> 8 & 0xFF;
                int j1 = l1 & 0xFF;
                this.planeEntity.field_70170_p.func_175688_a(EnumParticleTypes.SPELL, this.planeEntity.getPosX() - (double)MathHelper.func_76126_a((float)((this.planeEntity.field_70177_z - 50.0f) * ((float)Math.PI / 180))), this.planeEntity.getPosY() + 0.5, this.planeEntity.getPosZ() + (double)MathHelper.func_76134_b((float)((this.planeEntity.field_70177_z - 50.0f) * ((float)Math.PI / 180))), (double)((float)i2 / 255.0f), (double)((float)j2 / 255.0f), (double)((float)j1 / 255.0f), new int[0]);
                this.planeEntity.field_70170_p.func_175688_a(EnumParticleTypes.SPELL, this.planeEntity.getPosX() - (double)MathHelper.func_76126_a((float)((this.planeEntity.field_70177_z + 50.0f) * ((float)Math.PI / 180))), this.planeEntity.getPosY() + 0.5, this.planeEntity.getPosZ() + (double)MathHelper.func_76134_b((float)((this.planeEntity.field_70177_z + 50.0f) * ((float)Math.PI / 180))), (double)((float)i2 / 255.0f), (double)((float)j2 / 255.0f), (double)((float)j1 / 255.0f), new int[0]);
            }
            if (!this.planeEntity.field_70170_p.field_72995_K) {
                BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
                double range = this.fluid % 4;
                this.fire_fight(blockPos, range);
                if (this.planeEntity.field_70173_aa % 5 == 0) {
                    this.planeEntity.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.planeEntity.getPosX() - (double)MathHelper.func_76126_a((float)((this.planeEntity.field_70177_z - 50.0f) * ((float)Math.PI / 180))), this.planeEntity.getPosY() + 0.5, this.planeEntity.getPosZ() + (double)MathHelper.func_76134_b((float)((this.planeEntity.field_70177_z - 50.0f) * ((float)Math.PI / 180))), 0.0, 0.0, 0.0, new int[0]);
                    this.planeEntity.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.planeEntity.getPosX() - (double)MathHelper.func_76126_a((float)((this.planeEntity.field_70177_z + 50.0f) * ((float)Math.PI / 180))), this.planeEntity.getPosY() + 0.5, this.planeEntity.getPosZ() + (double)MathHelper.func_76134_b((float)((this.planeEntity.field_70177_z + 50.0f) * ((float)Math.PI / 180))), 0.0, 0.0, 0.0, new int[0]);
                    this.planeEntity.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.planeEntity.getPosX() - (double)(2.0f * MathHelper.func_76126_a((float)((this.planeEntity.field_70177_z - 80.0f) * ((float)Math.PI / 180)))), this.planeEntity.getPosY() + 0.5, this.planeEntity.getPosZ() + (double)(2.0f * MathHelper.func_76134_b((float)((this.planeEntity.field_70177_z - 80.0f) * ((float)Math.PI / 180)))), 0.0, 0.0, 0.0, new int[0]);
                    this.planeEntity.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.planeEntity.getPosX() - (double)(2.0f * MathHelper.func_76126_a((float)((this.planeEntity.field_70177_z + 80.0f) * ((float)Math.PI / 180)))), this.planeEntity.getPosY() + 0.5, this.planeEntity.getPosZ() + (double)(2.0f * MathHelper.func_76134_b((float)((this.planeEntity.field_70177_z + 80.0f) * ((float)Math.PI / 180)))), 0.0, 0.0, 0.0, new int[0]);
                    blockPos.func_189532_c(this.planeEntity.getPosX(), Math.min(255.0, this.planeEntity.getPosY() + 2.0), this.planeEntity.getPosZ());
                    blockPos.func_177963_a(Math.random() * 3.0, 0.0, Math.random() * 3.0);
                    for (int j = 0; j < 6; ++j) {
                        IBlockState blockState = this.planeEntity.field_70170_p.func_180495_p((BlockPos)blockPos);
                        this.extinguishFires((BlockPos)blockPos);
                        Block block = blockState.func_177230_c();
                        if (block instanceof IGrowable) {
                            ((IGrowable)block).func_176474_b(this.planeEntity.field_70170_p, this.planeEntity.field_70170_p.field_73012_v, (BlockPos)blockPos, blockState);
                            break;
                        }
                        blockPos.func_189536_c(EnumFacing.DOWN);
                    }
                    if (this.effect != null) {
                        for (EntityLiving entity : this.planeEntity.field_70170_p.func_72872_a(EntityLiving.class, AFFECT_ENTITIES.func_191194_a(this.planeEntity.func_174791_d()))) {
                            entity.func_70690_d(new PotionEffect(this.effect, 100));
                        }
                    }
                }
            }
        }
        return false;
    }

    private void fire_fight(BlockPos.MutableBlockPos blockPos, double range) {
        int i1 = this.effect == MobEffects.field_76426_n ? 10 : 3;
        block0: for (int i = 0; i < i1; ++i) {
            blockPos.func_189532_c(this.planeEntity.getPosX(), Math.min(255.0, this.planeEntity.getPosY() + 2.0), this.planeEntity.getPosZ());
            blockPos.func_177963_a(Math.random() * 3.0, 0.0, Math.random() * 3.0);
            for (int j = 0; j < 6; ++j) {
                IBlockState blockState = this.planeEntity.field_70170_p.func_180495_p((BlockPos)blockPos);
                this.extinguishFires((BlockPos)blockPos);
                if (!blockState.func_185895_e()) continue block0;
                blockPos.func_189536_c(EnumFacing.DOWN);
            }
        }
    }

    @Override
    public boolean onItemRightClick(EntityPlayer player, World world, EnumHand hand, ItemStack itemStack) {
        if (itemStack.func_77973_b() == Items.field_151068_bn && this.fluid < 20) {
            this.planeEntity.upgradeChanged();
            this.fluid = 60;
            List effectInstances = PotionUtils.func_185189_a((ItemStack)itemStack);
            this.effect = effectInstances.size() == 0 ? null : ((PotionEffect)effectInstances.get(0)).func_188419_a();
            if (!player.func_184812_l_()) {
                player.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
            }
        }
        return false;
    }

    @Override
    public void render(float partialticks, float scale) {
        if (!this.planeEntity.isLarge() || this.planeEntity instanceof HelicopterEntity) {
            SprayerModel.INSTANCE.func_78088_a(this.planeEntity, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, scale);
        } else {
            LargeSprayerModel.INSTANCE.func_78088_a(this.planeEntity, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, scale);
        }
    }

    private void extinguishFires(BlockPos pos) {
        IBlockState blockstate = this.planeEntity.field_70170_p.func_180495_p(pos);
        if (blockstate.func_177230_c() == Blocks.field_150480_ab) {
            this.planeEntity.field_70170_p.func_175698_g(pos);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }
}

