/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public abstract class Upgrade
implements INBTSerializable<NBTTagCompound> {
    private final UpgradeType type;
    protected final PlaneEntity planeEntity;

    public PlaneEntity getPlaneEntity() {
        return this.planeEntity;
    }

    public Upgrade(UpgradeType type, PlaneEntity planeEntity) {
        this.type = type;
        this.planeEntity = planeEntity;
    }

    public final UpgradeType getType() {
        return this.type;
    }

    public NonNullList<ItemStack> getDrops() {
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{this.getDrop()});
    }

    public ItemStack getDrop() {
        return this.type.getDrops();
    }

    public boolean onItemRightClick(EntityPlayer player, World world, EnumHand hand, ItemStack itemStack) {
        return false;
    }

    public boolean tick() {
        return false;
    }

    public boolean isEngine() {
        return false;
    }

    public abstract void render(float var1, float var2);

    public ResourceLocation getTexture() {
        return null;
    }

    public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }

    public NBTTagCompound serializeNBTData() {
        return new NBTTagCompound();
    }

    public void deserializeNBTData(NBTTagCompound nbt) {
    }

    public void onApply(ItemStack itemStack, EntityPlayer playerEntity) {
    }

    public void onRemove() {
    }

    public int getSeats() {
        return this.getType().occupyBackSeat ? 1 : 0;
    }
}

