/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer.utils;

import bre.fpsreducer.config.CommonConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class Logger {
    private static Minecraft mc;
    private static org.apache.logging.log4j.Logger logger;

    public static void init(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        mc = Minecraft.func_71410_x();
    }

    public static void debug(Object ... args) {
        if (CommonConfig.globalConfig.debugLog) {
            StringBuilder mes = new StringBuilder();
            for (Object obj : args) {
                if (obj instanceof String) {
                    mes.append(obj);
                    continue;
                }
                if (obj instanceof Number) {
                    mes.append(String.valueOf(obj));
                    continue;
                }
                try {
                    mes.append(String.valueOf(obj));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            logger.info(mes.toString());
            Logger.addChatLog(TextFormatting.GRAY + "D: " + mes.toString() + TextFormatting.RESET);
        }
    }

    public static void info(String str) {
        logger.info(str);
        Logger.addChatLog(TextFormatting.AQUA + "I: " + str + TextFormatting.RESET);
    }

    public static void warn(String str) {
        logger.warn(str);
        Logger.addChatLog(TextFormatting.YELLOW + "W: " + str + TextFormatting.RESET);
    }

    public static void error(String str) {
        logger.error(str);
        Logger.addChatLog(TextFormatting.RED + "E: " + str + TextFormatting.RESET);
    }

    private static void addChatLog(String str) {
        if (CommonConfig.globalConfig != null && CommonConfig.globalConfig.logInChat) {
            Logger.addChatMsg(str);
        }
    }

    public static void addChatMsg(String str) {
        if (mc != null && Logger.mc.field_71456_v != null) {
            Logger.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(str));
        }
    }
}

