/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer.config;

import bre.fpsreducer.config.GlobalConfig;
import bre.fpsreducer.config.PlayerConfig;
import bre.fpsreducer.gui.HudPos;
import bre.fpsreducer.utils.Logger;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class CommonConfig {
    protected Configuration cfg;
    public static GlobalConfig globalConfig = null;
    public static PlayerConfig playerConfig = null;
    public static CommonConfig currentConfig = null;
    private static final String configVersion = "5";
    public boolean enableFpsReducer;
    public int waitingTime;
    public int idleFPS;
    public int detectMoving;
    public static final int DETECTMOVING_OFF = 0;
    public static final int DETECTMOVING_RIDING_FLYING = 1;
    public static final int DETECTMOVING_ON = 2;
    public boolean ignoreHoldButton;
    public boolean reducingInBackground;
    public boolean suppressSound;
    public int suppressedVolume;
    public boolean inquireInitSetting;
    public boolean hudEnabled;
    private int hudReferencePos;
    public HudPos[] hudPos = new HudPos[9];
    public double hudScale;
    public int hudBehindChatBox;
    public static final int HUD_BEFIND_CHATBOX_KEEP = 0;
    public static final int HUD_BEHIND_CHATBOX_OFF = 1;
    public static final int HUD_BEHIND_CHATBOX_DODGE = 2;
    public int hudInfo;
    public static final int HUD_INFO_DISABLED = 0;
    public static final int HUD_INFO_FPS_CPU_LONG = 1;
    public static final int HUD_INFO_FPS_CPU_SHORT = 2;
    public static final int HUD_INFO_FPS_CPU_2LINES = 3;
    public static final int HUD_INFO_FPS_ONLY = 4;
    public static final int HUD_INFO_CPU_ONLY = 5;
    private Property enableFpsReducerProp;
    private Property waitingTimeProp;
    private Property idleFpsProp;
    private Property detectMovingProp;
    private Property ignoreHoldButtonProp;
    private Property reducingInBackgroundProp;
    private Property suppressSoundProp;
    private Property suppressedVolumeProp;
    private Property inquireInitSettingProp;
    private Property hudEnabledProp;
    private Property hudReferencePosProp;
    private Property[] hudOffsetProp = new Property[16];
    private Property[] hudAlignmentProp = new Property[8];
    private Property hudScaleProp;
    private Property hudBehindChatBoxProp;
    private Property hudInfoProp;
    protected boolean enableFpsReducerDefault;
    protected int waitingTimeDefault;
    protected int idleFPSDefault;
    protected int detectMovingDefault;
    protected boolean ignoreHoldButtonDefault;
    protected boolean reducingInBackgroundDefault;
    protected boolean suppressSoundDefalut;
    protected int suppressedVolumeDefalut;
    protected boolean inquireInitSettingDefalut;
    protected boolean hudEnabledDefault;
    protected int hudReferencePosDefault;
    protected HudPos[] hudPosDefault = new HudPos[9];
    protected double hudScaleDefault;
    protected int hudBehindChatBoxDefault;
    protected int hudInfoDefault;
    public HudPos curHudPos;

    public CommonConfig(File configFile) {
        this.cfg = new Configuration(configFile, configVersion);
        for (int i = 0; i < 9; ++i) {
            this.hudPos[i] = new HudPos(i);
            this.hudPosDefault[i] = new HudPos(i);
        }
    }

    public void initConfig() {
        try {
            this.loadConfig();
        }
        catch (Exception e) {
            Logger.error("FpsReducer config file access error.");
        }
        finally {
            this.convertVersion();
            this.saveConfig();
        }
    }

    protected void initDefaultValues() {
        this.enableFpsReducerDefault = true;
        this.waitingTimeDefault = 300;
        this.idleFPSDefault = 10;
        this.detectMovingDefault = 1;
        this.ignoreHoldButtonDefault = false;
        this.reducingInBackgroundDefault = true;
        this.suppressSoundDefalut = true;
        this.suppressedVolumeDefalut = 20;
        this.inquireInitSettingDefalut = false;
        this.hudEnabledDefault = true;
        this.hudReferencePosDefault = 3;
        this.hudPosDefault[1].setOffset(2, 2);
        this.hudPosDefault[2].setOffset(0, 2);
        this.hudPosDefault[3].setOffset(-2, 2);
        this.hudPosDefault[4].setOffset(-2, 0);
        this.hudPosDefault[5].setOffset(-2, -2);
        this.hudPosDefault[6].setOffset(0, -2);
        this.hudPosDefault[7].setOffset(2, -2);
        this.hudPosDefault[8].setOffset(2, 0);
        this.hudPosDefault[1].alignment = 0;
        this.hudPosDefault[2].alignment = 2;
        this.hudPosDefault[3].alignment = 1;
        this.hudPosDefault[4].alignment = 1;
        this.hudPosDefault[5].alignment = 1;
        this.hudPosDefault[6].alignment = 2;
        this.hudPosDefault[7].alignment = 0;
        this.hudPosDefault[8].alignment = 0;
        this.hudScaleDefault = 1.0;
        this.hudBehindChatBoxDefault = 2;
        this.hudInfoDefault = 4;
    }

    public void loadConfig() {
        this.cfg.load();
        this.initDefaultValues();
        this.enableFpsReducerProp = this.cfg.get("common", "enableFpsReducer", this.enableFpsReducerDefault, "Enable FPS Reducer features.");
        this.waitingTimeProp = this.cfg.get("common", "waitingTime", this.waitingTimeDefault, "Waiting time(sec) until reducing FPS. (0:OFF)", 0, 86400);
        this.idleFpsProp = this.cfg.get("common", "idleFPS", this.idleFPSDefault, "Frame rate during reducing.", 1, 260);
        this.detectMovingProp = this.cfg.get("common", "detectMoving", this.detectMovingDefault, "Detect movement of player position.(0:OFF, 1:Riding/Flying, 2:Always)");
        this.ignoreHoldButtonProp = this.cfg.get("common", "ignoreHoldButton", this.ignoreHoldButtonDefault, "Ignore the mouse button holding.");
        this.reducingInBackgroundProp = this.cfg.get("common", "reducingInBackground", this.reducingInBackgroundDefault, "Force reducing FPS if the window is inactive.");
        this.suppressSoundProp = this.cfg.get("common", "suppressSound", this.suppressSoundDefalut, "Suppress master volume if the window is inactive.");
        this.suppressedVolumeProp = this.cfg.get("common", "suppressedVolume", this.suppressedVolumeDefalut, "Suppression master volume ratio in inactive (0-100).", 0, 100);
        this.inquireInitSettingProp = this.cfg.get("common", "inquireInitSetting", this.inquireInitSettingDefalut, "Inquire easy initial configuration in chat. Since it works only in player config mode,\nplayer config mode is forcibly enabled at initial creation of a player config.\nOnce easy config is selected in chat, no further inquiry will be displayed.");
        this.hudEnabledProp = this.cfg.get("common", "hudEnabled", this.hudEnabledDefault, "Enable HUD.");
        this.hudReferencePosProp = this.cfg.get("common", "hudReferencePos", this.hudReferencePosDefault, "Reference position of HUD. (0:off)");
        this.hudScaleProp = this.cfg.get("common", "hudScale", this.hudScaleDefault, "HUD scale (default: 1.0)");
        this.hudBehindChatBoxProp = this.cfg.get("common", "hudBehindChatBox", this.hudBehindChatBoxDefault, "Behavior of HUD display when a chat window opened. (0:keep to display, 1:off, 2:dodge a chat box)");
        this.hudInfoProp = this.cfg.get("common", "hudInfo", this.hudInfoDefault, "HUD information (1:FPS/CPU(long), 2:FPS/CPU(short), 3:FPS/CPU(2lines), 4:FPS only, 5:CPU only)");
        this.cfg.setCategoryComment("common.hud_offset", "HUD offsets from reference positions at the screen edge.");
        this.hudOffsetProp[0] = this.cfg.get("common.hud_offset", "topLeft_X", this.hudPosDefault[1].offsetX, "");
        this.hudOffsetProp[1] = this.cfg.get("common.hud_offset", "topLeft_Y", this.hudPosDefault[1].offsetY, "");
        this.hudOffsetProp[2] = this.cfg.get("common.hud_offset", "topCenter_X", this.hudPosDefault[2].offsetX, "");
        this.hudOffsetProp[3] = this.cfg.get("common.hud_offset", "topCenter_Y", this.hudPosDefault[2].offsetY, "");
        this.hudOffsetProp[4] = this.cfg.get("common.hud_offset", "topRight_X", this.hudPosDefault[3].offsetX, "");
        this.hudOffsetProp[5] = this.cfg.get("common.hud_offset", "topRight_Y", this.hudPosDefault[3].offsetY, "");
        this.hudOffsetProp[6] = this.cfg.get("common.hud_offset", "centerRight_X", this.hudPosDefault[4].offsetX, "");
        this.hudOffsetProp[7] = this.cfg.get("common.hud_offset", "centerRight_Y", this.hudPosDefault[4].offsetY, "");
        this.hudOffsetProp[8] = this.cfg.get("common.hud_offset", "bottomRight_X", this.hudPosDefault[5].offsetX, "");
        this.hudOffsetProp[9] = this.cfg.get("common.hud_offset", "bottomRight_Y", this.hudPosDefault[5].offsetY, "");
        this.hudOffsetProp[10] = this.cfg.get("common.hud_offset", "bottomCenter_X", this.hudPosDefault[6].offsetX, "");
        this.hudOffsetProp[11] = this.cfg.get("common.hud_offset", "bottomCenter_Y", this.hudPosDefault[6].offsetY, "");
        this.hudOffsetProp[12] = this.cfg.get("common.hud_offset", "bottomLeft_X", this.hudPosDefault[7].offsetX, "");
        this.hudOffsetProp[13] = this.cfg.get("common.hud_offset", "bottomLeft_Y", this.hudPosDefault[7].offsetY, "");
        this.hudOffsetProp[14] = this.cfg.get("common.hud_offset", "centerLeft_X", this.hudPosDefault[8].offsetX, "");
        this.hudOffsetProp[15] = this.cfg.get("common.hud_offset", "centerLeft_Y", this.hudPosDefault[8].offsetY, "");
        this.hudAlignmentProp[0] = this.cfg.get("common.hud_alignment", "topLeft", this.hudPosDefault[1].alignment, "");
        this.hudAlignmentProp[1] = this.cfg.get("common.hud_alignment", "topCenter", this.hudPosDefault[2].alignment, "");
        this.hudAlignmentProp[2] = this.cfg.get("common.hud_alignment", "topRight", this.hudPosDefault[3].alignment, "");
        this.hudAlignmentProp[3] = this.cfg.get("common.hud_alignment", "centerRight", this.hudPosDefault[4].alignment, "");
        this.hudAlignmentProp[4] = this.cfg.get("common.hud_alignment", "bottomRight", this.hudPosDefault[5].alignment, "");
        this.hudAlignmentProp[5] = this.cfg.get("common.hud_alignment", "bottomCenter", this.hudPosDefault[6].alignment, "");
        this.hudAlignmentProp[6] = this.cfg.get("common.hud_alignment", "bottomLeft", this.hudPosDefault[7].alignment, "");
        this.hudAlignmentProp[7] = this.cfg.get("common.hud_alignment", "centerLeft", this.hudPosDefault[8].alignment, "");
        this.readValuesFromProp();
        this.setHudReferencePos(this.hudReferencePos);
    }

    private void readValuesFromProp() {
        this.enableFpsReducer = this.enableFpsReducerProp.getBoolean();
        this.waitingTime = this.waitingTimeProp.getInt();
        this.idleFPS = this.idleFpsProp.getInt();
        this.detectMoving = this.detectMovingProp.getInt();
        this.ignoreHoldButton = this.ignoreHoldButtonProp.getBoolean();
        this.reducingInBackground = this.reducingInBackgroundProp.getBoolean();
        this.suppressSound = this.suppressSoundProp.getBoolean();
        this.suppressedVolume = this.suppressedVolumeProp.getInt();
        this.inquireInitSetting = this.inquireInitSettingProp.getBoolean();
        this.hudEnabled = this.hudEnabledProp.getBoolean();
        this.hudReferencePos = this.hudReferencePosProp.getInt();
        this.hudScale = this.hudScaleProp.getDouble();
        this.hudBehindChatBox = this.hudBehindChatBoxProp.getInt();
        this.hudInfo = this.hudInfoProp.getInt();
        for (int i = 0; i < 8; ++i) {
            this.hudPos[i + 1].setOffset(this.hudOffsetProp[i * 2].getInt(), this.hudOffsetProp[i * 2 + 1].getInt());
            this.hudPos[i + 1].alignment = this.hudAlignmentProp[i].getInt();
        }
    }

    protected void saveConfig() {
        this.waitingTimeProp.setValue(this.waitingTime);
        this.idleFpsProp.setValue(this.idleFPS);
        this.enableFpsReducerProp.setValue(this.enableFpsReducer);
        this.detectMovingProp.setValue(this.detectMoving);
        this.ignoreHoldButtonProp.setValue(this.ignoreHoldButton);
        this.reducingInBackgroundProp.setValue(this.reducingInBackground);
        this.suppressSoundProp.setValue(this.suppressSound);
        this.suppressedVolumeProp.setValue(this.suppressedVolume);
        this.inquireInitSettingProp.setValue(this.inquireInitSetting);
        this.hudEnabledProp.setValue(this.hudEnabled);
        this.hudReferencePosProp.setValue(this.hudReferencePos);
        this.hudScaleProp.setValue(this.hudScale);
        this.hudBehindChatBoxProp.setValue(this.hudBehindChatBox);
        this.hudInfoProp.setValue(this.hudInfo);
        for (int i = 0; i < 8; ++i) {
            this.hudOffsetProp[i * 2].setValue(this.hudPos[i + 1].offsetX);
            this.hudOffsetProp[i * 2 + 1].setValue(this.hudPos[i + 1].offsetY);
            this.hudAlignmentProp[i].setValue(this.hudPos[i + 1].alignment);
        }
        this.cfg.save();
    }

    protected void convertVersion() {
        if (this.getLoadedConfigVersionInt() <= 3) {
            this.hudInfo = 4;
        }
        if (this.hudInfo == 0) {
            this.hudEnabled = false;
            this.hudInfo = 4;
        }
    }

    protected void removeKey(String category, String key) {
        if (this.cfg.hasKey(category, key)) {
            this.cfg.moveProperty(category, key, "work");
            this.cfg.removeCategory(this.cfg.getCategory("work"));
        }
    }

    public static void saveCurrentConfig() {
        if (CommonConfig.isPlayerConfig()) {
            playerConfig.saveConfig();
        }
        globalConfig.saveConfig();
    }

    public static boolean isPlayerConfig() {
        return CommonConfig.globalConfig.enablePerPlayerConfig && playerConfig != null && CommonConfig.playerConfig.usePlayerConfig;
    }

    public static void toggleConfig() {
        if (playerConfig == null) {
            PlayerConfig.readPlayerConfig();
        }
        if (playerConfig != null) {
            CommonConfig.playerConfig.usePlayerConfig = !CommonConfig.playerConfig.usePlayerConfig;
            currentConfig = CommonConfig.isPlayerConfig() ? playerConfig : globalConfig;
            playerConfig.saveConfig();
        }
    }

    protected int getLoadedConfigVersionInt() {
        if (this.cfg.getLoadedConfigVersion() == null) {
            return 0;
        }
        return Integer.parseInt(this.cfg.getLoadedConfigVersion());
    }

    public void setHudReferencePos(int loc) {
        this.hudReferencePos = loc;
        this.curHudPos = this.hudPos[loc];
    }

    public int getHudReferencePos() {
        return this.hudReferencePos;
    }

    public void resetHudOffsetsAndAlignments() {
        int i;
        for (i = 0; i < 16; ++i) {
            this.hudOffsetProp[i].setToDefault();
        }
        for (i = 0; i < 8; ++i) {
            this.hudAlignmentProp[i].setToDefault();
        }
        this.readValuesFromProp();
    }
}

