/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.hardcorerevival.ModConfig;
import net.blay09.mods.hardcorerevival.capability.CapabilityHardcoreRevival;
import net.blay09.mods.hardcorerevival.capability.IHardcoreRevival;
import net.blay09.mods.hardcorerevival.network.MessageDeathTime;
import net.blay09.mods.hardcorerevival.network.MessageDie;
import net.blay09.mods.hardcorerevival.network.NetworkHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerHandler {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            NBTTagCompound data = event.player.getEntityData().func_74775_l("PlayerPersisted");
            IHardcoreRevival revival = (IHardcoreRevival)event.player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
            if (revival != null) {
                CapabilityHardcoreRevival.REVIVAL_CAPABILITY.readNBT((Object)revival, null, (NBTBase)data.func_74775_l("HardcoreRevival"));
            }
            NetworkHandler.instance.sendTo((IMessage)new MessageDeathTime(revival != null ? revival.getDeathTime() : 0), (EntityPlayerMP)event.player);
            if (revival != null && revival.getDeathTime() >= ModConfig.maxDeathTicks) {
                NetworkHandler.instance.sendTo((IMessage)new MessageDie(), (EntityPlayerMP)event.player);
            }
        }
    }

    @SubscribeEvent
    public void onCapabilityInject(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerMP) {
            event.addCapability(CapabilityHardcoreRevival.REGISTRY_NAME, new ICapabilityProvider(){
                private IHardcoreRevival revival;

                public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == CapabilityHardcoreRevival.REVIVAL_CAPABILITY;
                }

                @Nullable
                public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                    if (capability == CapabilityHardcoreRevival.REVIVAL_CAPABILITY) {
                        if (this.revival == null) {
                            this.revival = (IHardcoreRevival)CapabilityHardcoreRevival.REVIVAL_CAPABILITY.getDefaultInstance();
                        }
                        return (T)this.revival;
                    }
                    return null;
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        NBTBase tag;
        NBTTagCompound data = event.player.getEntityData().func_74775_l("PlayerPersisted");
        IHardcoreRevival revival = (IHardcoreRevival)event.player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
        if (revival != null && (tag = CapabilityHardcoreRevival.REVIVAL_CAPABILITY.writeNBT((Object)revival, null)) != null) {
            data.func_74782_a("HardcoreRevival", tag);
            event.player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)data);
        }
    }
}

