/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.ModConfig;
import net.blay09.mods.hardcorerevival.PlayerKnockedOutEvent;
import net.blay09.mods.hardcorerevival.capability.CapabilityHardcoreRevival;
import net.blay09.mods.hardcorerevival.capability.IHardcoreRevival;
import net.blay09.mods.hardcorerevival.network.MessageDie;
import net.blay09.mods.hardcorerevival.network.NetworkHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DeathHandler {
    public static final String IGNORE_REVIVAL_DEATH = "IgnoreRevivalDeath";

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            MinecraftServer server;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (event.getSource() == DamageSource.field_76380_i) {
                player.getEntityData().func_74757_a(IGNORE_REVIVAL_DEATH, true);
                NetworkHandler.instance.sendTo((IMessage)new MessageDie(), (EntityPlayerMP)player);
                return;
            }
            if (event.getSource() == HardcoreRevival.notRescuedInTime || player.getEntityData().func_74767_n(IGNORE_REVIVAL_DEATH)) {
                return;
            }
            MinecraftForge.EVENT_BUS.post((Event)new PlayerKnockedOutEvent(player, event.getSource()));
            if (ModConfig.glowOnDeath) {
                player.func_184195_f(true);
            }
            event.setCanceled(true);
            if (player.field_70170_p.func_82736_K().func_82766_b("showDeathMessages") && (server = player.field_70170_p.func_73046_m()) != null) {
                Team team = player.func_96124_cp();
                if (team != null && team.func_178771_j() != Team.EnumVisible.ALWAYS) {
                    if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OTHER_TEAMS) {
                        server.func_184103_al().func_177453_a(player, player.func_110142_aN().func_151521_b());
                    } else if (team.func_178771_j() == Team.EnumVisible.HIDE_FOR_OWN_TEAM) {
                        server.func_184103_al().func_177452_b(player, player.func_110142_aN().func_151521_b());
                    }
                } else {
                    server.func_184103_al().func_148539_a(player.func_110142_aN().func_151521_b());
                }
            }
        }
    }

    @SubscribeEvent
    public void onDeathUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.func_110143_aJ() <= 0.0f && !event.player.getEntityData().func_74767_n(IGNORE_REVIVAL_DEATH)) {
            IHardcoreRevival revival;
            if (event.player.field_70725_aQ == 19) {
                event.player.field_70725_aQ = 18;
            }
            if ((revival = (IHardcoreRevival)event.player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null)) != null) {
                revival.setDeathTime(revival.getDeathTime() + 1);
                if (revival.getDeathTime() >= ModConfig.maxDeathTicks) {
                    event.player.getEntityData().func_74757_a(IGNORE_REVIVAL_DEATH, true);
                    NetworkHandler.instance.sendTo((IMessage)new MessageDie(), (EntityPlayerMP)event.player);
                    event.player.func_110142_aN().func_94547_a(HardcoreRevival.notRescuedInTime, 0.0f, 0.0f);
                    event.player.func_70645_a(HardcoreRevival.notRescuedInTime);
                    revival.setDeathTime(0);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        IHardcoreRevival revival;
        event.player.getEntityData().func_82580_o(IGNORE_REVIVAL_DEATH);
        if (ModConfig.glowOnDeath) {
            event.player.func_184195_f(false);
        }
        if ((revival = (IHardcoreRevival)event.player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null)) != null) {
            revival.setDeathTime(0);
        }
    }
}

