/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.client;

import net.blay09.mods.hardcorerevival.CommonProxy;
import net.blay09.mods.hardcorerevival.ModConfig;
import net.blay09.mods.hardcorerevival.client.GuiHelper;
import net.blay09.mods.hardcorerevival.network.MessageDie;
import net.blay09.mods.hardcorerevival.network.MessageRevival;
import net.blay09.mods.hardcorerevival.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Mouse;

public class ClientProxy
extends CommonProxy {
    private boolean isKnockedOut;
    private boolean acceptedDeath;
    private int deathTime;
    private float enableButtonTimer;
    private GuiButton buttonDie;
    private float prevChatHeight = -1.0f;
    private boolean isRescuing;
    private int targetEntity = -1;
    private float targetProgress;

    @SubscribeEvent
    public void onOpenGui(GuiOpenEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            if (event.getGui() instanceof GuiGameOver && this.isKnockedOut && !this.acceptedDeath) {
                event.setGui(null);
            } else if (this.isKnockedOut && event.getGui() instanceof GuiInventory) {
                event.setGui(null);
            }
        }
    }

    @SubscribeEvent
    public void onFov(FOVUpdateEvent event) {
        if (this.isKnockedOut) {
            event.setNewfov(0.5f);
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Chat event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && this.isKnockedOut && mc.field_71462_r != null) {
            this.prevChatHeight = mc.field_71474_y.field_96694_H;
            mc.field_71474_y.field_96694_H = 0.1f;
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.PORTAL) {
            Entity entity;
            Minecraft mc = Minecraft.func_71410_x();
            if (this.isKnockedOut) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
                GuiHelper.drawGradientRectW(0, 0, mc.field_71443_c, mc.field_71440_d, 0x60500000, -1862336512);
                GlStateManager.func_179121_F();
                if (mc.field_71462_r == null) {
                    mc.field_71466_p.func_175063_a(I18n.func_135052_a((String)"gui.hardcorerevival.open_death_screen", (Object[])new Object[]{mc.field_71474_y.field_74310_D.getDisplayName()}), 5.0f, 5.0f, -1);
                    mc.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.hardcorerevival.rescue_time_left", (Object[])new Object[]{Math.max(0, (ModConfig.maxDeathTicks - this.deathTime) / 20)}), 5, 7 + mc.field_71466_p.field_78288_b, 0xFFFFFF);
                    mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                }
            } else if (this.targetEntity != -1 && (entity = mc.field_71441_e.func_73045_a(this.targetEntity)) instanceof EntityPlayer) {
                String s = I18n.func_135052_a((String)"gui.hardcorerevival.rescuing", (Object[])new Object[]{((EntityPlayer)entity).getDisplayNameString()});
                if (this.targetProgress >= 0.75f) {
                    s = s + " ...";
                } else if (this.targetProgress >= 0.5f) {
                    s = s + " ..";
                } else if (this.targetProgress >= 0.25f) {
                    s = s + " .";
                }
                mc.field_71466_p.func_78276_b(s, event.getResolution().func_78326_a() / 2 - mc.field_71466_p.func_78256_a(s) / 2, event.getResolution().func_78328_b() / 2 + 30, -1);
                mc.func_110434_K().func_110577_a(Gui.field_110324_m);
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.CHAT && this.prevChatHeight != -1.0f) {
            Minecraft.func_71410_x().field_71474_y.field_96694_H = this.prevChatHeight;
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71439_g.func_110143_aJ() <= 0.0f) {
            while (mc.field_71474_y.field_74316_C.func_151468_f()) {
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null) {
                if (mc.field_71439_g.func_110143_aJ() <= 0.0f) {
                    if (!this.isKnockedOut && !this.acceptedDeath) {
                        this.deathTime = 0;
                        this.isKnockedOut = true;
                        mc.func_147108_a((GuiScreen)new GuiChat());
                    }
                    if (mc.field_71439_g.field_70725_aQ == 19) {
                        mc.field_71439_g.field_70725_aQ = 18;
                    }
                    ++this.deathTime;
                } else {
                    this.isKnockedOut = false;
                    this.acceptedDeath = false;
                    this.deathTime = 0;
                    if (Mouse.isButtonDown((int)1)) {
                        if (!this.isRescuing) {
                            NetworkHandler.instance.sendToServer((IMessage)new MessageRevival(true));
                            this.isRescuing = true;
                        }
                    } else if (this.isRescuing) {
                        NetworkHandler.instance.sendToServer((IMessage)new MessageRevival(false));
                        this.isRescuing = false;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        Minecraft mc = event.getGui().field_146297_k;
        if (mc.field_71439_g != null && this.isKnockedOut && event.getGui() instanceof GuiChat) {
            GuiScreen gui = event.getGui();
            this.enableButtonTimer = 0.0f;
            this.buttonDie = new GuiButton(-2, gui.field_146294_l / 2 - 100, gui.field_146295_m / 2 - 30, I18n.func_135052_a((String)"gui.hardcorerevival.die", (Object[])new Object[0]));
            this.buttonDie.field_146124_l = false;
            event.getButtonList().add(this.buttonDie);
        }
    }

    @SubscribeEvent
    public void onActionPerformed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getButton() == this.buttonDie) {
            event.getButton().func_146113_a(Minecraft.func_71410_x().func_147118_V());
            NetworkHandler.instance.sendToServer((IMessage)new MessageDie());
            this.acceptedDeath = true;
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        GuiScreen gui = event.getGui();
        Minecraft mc = gui.field_146297_k;
        if (mc.field_71439_g != null && this.isKnockedOut && gui instanceof GuiChat) {
            this.enableButtonTimer += event.getRenderPartialTicks();
            if (this.buttonDie != null) {
                if (this.enableButtonTimer >= 40.0f) {
                    this.buttonDie.field_146124_l = true;
                    this.buttonDie.field_146126_j = I18n.func_135052_a((String)"gui.hardcorerevival.die", (Object[])new Object[0]);
                } else if (this.enableButtonTimer >= 30.0f) {
                    this.buttonDie.field_146126_j = "... " + I18n.func_135052_a((String)"gui.hardcorerevival.die", (Object[])new Object[0]) + " ...";
                } else if (this.enableButtonTimer >= 20.0f) {
                    this.buttonDie.field_146126_j = ".. " + I18n.func_135052_a((String)"gui.hardcorerevival.die", (Object[])new Object[0]) + " ..";
                } else if (this.enableButtonTimer >= 10.0f) {
                    this.buttonDie.field_146126_j = ". " + I18n.func_135052_a((String)"gui.hardcorerevival.die", (Object[])new Object[0]) + " .";
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            gui.func_73732_a(mc.field_71466_p, I18n.func_135052_a((String)"gui.hardcorerevival.knocked_out", (Object[])new Object[0]), gui.field_146294_l / 2 / 2, 30, 0xFFFFFF);
            GlStateManager.func_179121_F();
            gui.func_73732_a(mc.field_71466_p, I18n.func_135052_a((String)"gui.hardcorerevival.rescue_time_left", (Object[])new Object[]{Math.max(0, (ModConfig.maxDeathTicks - this.deathTime) / 20)}), gui.field_146294_l / 2, gui.field_146295_m / 2 + 10, 0xFFFFFF);
        } else if (this.buttonDie != null) {
            this.buttonDie.field_146125_m = false;
        }
    }

    @Override
    public void receiveDeathTime(int deathTime) {
        this.deathTime = deathTime;
    }

    @Override
    public void receiveRevivalProgress(int entityId, float progress) {
        this.targetEntity = entityId;
        this.targetProgress = progress;
    }

    @Override
    public void receiveDeath() {
        this.isKnockedOut = true;
        this.acceptedDeath = true;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            if (ModConfig.glowOnDeath) {
                mc.field_71439_g.func_184195_f(false);
                mc.field_71439_g.func_70052_a(6, false);
            }
            mc.field_71439_g.field_70128_L = true;
        }
    }
}

