/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.recipes;

import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.recipes.ICraftingInventory;
import crafttweaker.api.recipes.ICraftingRecipe;
import crafttweaker.api.recipes.IRecipeAction;
import crafttweaker.api.recipes.IRecipeFunction;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public abstract class MCRecipeBase
implements IRecipe,
ICraftingRecipe {
    protected final ItemStack outputStack;
    protected final IItemStack output;
    protected final IRecipeFunction recipeFunction;
    protected final IRecipeAction recipeAction;
    protected final boolean hidden;
    protected NonNullList<Ingredient> ingredientList;
    protected ResourceLocation recipeNameLocation = new ResourceLocation("crafttweaker", "unInitializedRecipeName");

    MCRecipeBase(IItemStack output, NonNullList<Ingredient> ingredientList, IRecipeFunction recipeFunction, IRecipeAction recipeAction, boolean hidden) {
        this.output = output;
        this.outputStack = CraftTweakerMC.getItemStack(output);
        this.ingredientList = ingredientList;
        this.recipeFunction = recipeFunction;
        this.recipeAction = recipeAction;
        this.hidden = hidden;
    }

    public ItemStack func_77571_b() {
        return this.outputStack.func_77946_l();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredientList;
    }

    public boolean func_192399_d() {
        return this.hidden;
    }

    public String func_193358_e() {
        return "";
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        this.recipeNameLocation = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.recipeNameLocation;
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }

    public IRecipeAction getRecipeAction() {
        return this.recipeAction;
    }

    @Override
    public boolean hasRecipeAction() {
        return this.recipeAction != null;
    }

    @Override
    public boolean hasRecipeFunction() {
        return this.recipeFunction != null;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public String getFullResourceName() {
        return String.valueOf(this.getRegistryName());
    }

    @Override
    public String getResourceDomain() {
        return this.getRegistryName() == null ? "null" : this.getRegistryName().func_110624_b();
    }

    @Override
    public String getName() {
        return this.getRegistryName() != null ? this.getRegistryName().func_110623_a() : "null";
    }

    @Override
    public IItemStack getOutput() {
        return this.output;
    }

    public boolean isVisible() {
        return !this.func_192399_d();
    }

    @Override
    public void applyTransformers(ICraftingInventory inventory, IPlayer byPlayer) {
        if (inventory.getInternal() instanceof InventoryCrafting) {
            this.applyTransformers((InventoryCrafting)inventory.getInternal(), byPlayer);
        }
    }

    public abstract void applyTransformers(InventoryCrafting var1, IPlayer var2);

    @Override
    public boolean matches(ICraftingInventory inventory) {
        return inventory.getInternal() instanceof InventoryCrafting && this.func_77569_a((InventoryCrafting)inventory.getInternal(), inventory.getPlayer() == null ? null : CraftTweakerMC.getWorld(inventory.getPlayer().getWorld()));
    }

    @Override
    public IItemStack getCraftingResult(ICraftingInventory inventory) {
        if (inventory.getInternal() instanceof InventoryCrafting) {
            return CraftTweakerMC.getIItemStack(this.func_77572_b((InventoryCrafting)inventory));
        }
        return null;
    }

    public abstract MCRecipeBase update();
}

