/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.tileentity.energy;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyCapability {
    private int energy;
    private int capacity;
    private int maxReceive;
    private int maxExtract;
    private IEnergyStorage storage = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int energyReceived = Math.min(EnergyCapability.this.capacity - EnergyCapability.this.energy, Math.min(EnergyCapability.this.maxReceive, maxReceive));
            if (!simulate) {
                EnergyCapability.this.energy = EnergyCapability.this.energy + energyReceived;
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int energyExtracted = Math.min(EnergyCapability.this.energy, Math.min(EnergyCapability.this.maxExtract, maxExtract));
            if (!simulate) {
                EnergyCapability.this.energy = EnergyCapability.this.energy - energyExtracted;
            }
            return energyExtracted;
        }

        public int getEnergyStored() {
            return EnergyCapability.this.energy;
        }

        public int getMaxEnergyStored() {
            return EnergyCapability.this.capacity;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    };

    public EnergyCapability(int capacity, int maxReceive, int maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public void setEnergyStored(int energy) {
        this.energy = energy;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74762_e("Energy");
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.energy < 0) {
            this.energy = 0;
        }
        nbt.func_74768_a("Energy", this.energy);
        return nbt;
    }

    public IEnergyStorage getStorage() {
        return this.storage;
    }
}

