/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.mining_helmet;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class MiningHelmetConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ServerConfig SERVER;

    public static boolean helmetCoversFace() {
        return (Boolean)MiningHelmetConfig.CLIENT.helmetCoversFace.get();
    }

    public static int lightRefreshRate() {
        return (Integer)MiningHelmetConfig.CLIENT.lightRefreshRate.get();
    }

    public static int maxVisibleDistance() {
        return (Integer)MiningHelmetConfig.CLIENT.maxVisibleDistance.get();
    }

    public static boolean seeThroughWalls() {
        return (Boolean)MiningHelmetConfig.CLIENT.seeThroughWalls.get();
    }

    public static int zombieHelmetSpawnChance() {
        return (Integer)MiningHelmetConfig.SERVER.zombieHelmetSpawnChance.get();
    }

    private static String translate(String key) {
        return new String("mining_helmet.config." + key + ".name");
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)pair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        pair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER = (ServerConfig)pair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    private static class ServerConfig {
        public final ForgeConfigSpec.ConfigValue<Integer> zombieHelmetSpawnChance;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Server and Client side changes.").push("common");
            this.zombieHelmetSpawnChance = builder.translation(MiningHelmetConfig.translate("zombieHelmetSpawnChance")).comment("The chance for a Zombie to spawn with a Mining Helmet (1 in x, 0 prevents them from spawning with helmets)").define("zombieHelmetSpawnChance", (Object)20);
            builder.pop();
        }
    }

    private static class ClientConfig {
        public final ForgeConfigSpec.ConfigValue<Boolean> helmetCoversFace;
        public final ForgeConfigSpec.ConfigValue<Integer> lightRefreshRate;
        public final ForgeConfigSpec.ConfigValue<Integer> maxVisibleDistance;
        public final ForgeConfigSpec.ConfigValue<Boolean> seeThroughWalls;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Client side changes.").push("client");
            this.helmetCoversFace = builder.translation(MiningHelmetConfig.translate("helmetCoversFace")).comment("The Mining Helmet will cover the face of whatever mob is wearing it.").define("helmetCoversFace", true);
            builder.push("dynamic_lighting");
            this.lightRefreshRate = builder.translation(MiningHelmetConfig.translate("lightRefreshRate")).comment("The rate at which the Mining Helmet refreshes it's light (measured in ticks). Lower values are smoother but result in worse fps.").defineInRange("lightRefreshRate", 2, 1, Integer.MAX_VALUE);
            this.maxVisibleDistance = builder.translation(MiningHelmetConfig.translate("maxVisibleDistance")).comment("How far away you should be able to see light from a mining helmet from other mobs (measured in blocks). 0 for infinite distance. Use this to prevent far away mobs from causing light updates.").defineInRange("maxVisibleDistance", 128, 0, Integer.MAX_VALUE);
            this.seeThroughWalls = builder.translation(MiningHelmetConfig.translate("seeThroughWalls")).comment("Should dynamic lighting still occur if an entity is behind a wall. Turning this on may impact performance, but allows light to be seen around corners.").define("seeThroughWalls", false);
            builder.pop();
            builder.pop();
        }
    }
}

