/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lava_monster;

import com.google.common.collect.Lists;
import com.legacy.lava_monster.LavaEntityTypes;
import com.legacy.lava_monster.LavaMonsterConfig;
import com.legacy.lava_monster.entity.LavaMonsterEntity;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class LavaMonsterSpawnEvent {
    private static final int maxNumberOfCreature = 10;
    private int spawnTime = 0;
    private HashMap<ChunkPos, Boolean> eligibleChunksForSpawning = new HashMap();

    public static boolean canLavaMonsterSpawnAtLocation(World world, BlockPos pos) {
        return (!LavaMonsterConfig.depthHazard || LavaMonsterConfig.depthHazard && pos.func_177956_o() <= 16 || world.func_230315_m_().func_236040_e_()) && world.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l && world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150353_l;
    }

    private int performSpawning(ServerWorld world) {
        if (++this.spawnTime < LavaMonsterConfig.spawnFrequency) {
            return 0;
        }
        this.eligibleChunksForSpawning.clear();
        if (!world.func_217369_A().isEmpty()) {
            for (PlayerEntity player : world.func_217369_A()) {
                int chunkX = MathHelper.func_76128_c((double)(player.func_226277_ct_() / 16.0));
                int chunkZ = MathHelper.func_76128_c((double)(player.func_226281_cx_() / 16.0));
                int spawnRange = 8;
                for (int x = -spawnRange; x <= spawnRange; ++x) {
                    for (int z = -spawnRange; z <= spawnRange; ++z) {
                        boolean isEdge = x == -spawnRange || x == spawnRange || z == -spawnRange || z == spawnRange;
                        ChunkPos chunkCoord = new ChunkPos(x + chunkX, z + chunkZ);
                        if (!isEdge) {
                            this.eligibleChunksForSpawning.put(chunkCoord, false);
                            continue;
                        }
                        if (this.eligibleChunksForSpawning.containsKey(chunkCoord)) continue;
                        this.eligibleChunksForSpawning.put(chunkCoord, true);
                    }
                }
            }
        }
        int numberSpawned = 0;
        BlockPos spawnCoords = world.func_241135_u_();
        if (this.getLavaMonsters((World)world).size() <= 10 * this.eligibleChunksForSpawning.size() / 256) {
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>(this.eligibleChunksForSpawning.keySet());
            if (chunks.isEmpty()) {
                return numberSpawned;
            }
            Collections.shuffle(chunks);
            block3: for (ChunkPos chunkCoord : chunks) {
                if (this.eligibleChunksForSpawning.get(chunkCoord).booleanValue()) continue;
                BlockPos chunkPos = this.getRandomSpawningPointInChunk((World)world, chunkCoord.field_77276_a, chunkCoord.field_77275_b);
                int x = chunkPos.func_177958_n();
                int y = chunkPos.func_177956_o();
                int z = chunkPos.func_177952_p();
                int groupRadius = 6;
                int groupSpawnAttempt = 3;
                while (groupSpawnAttempt-- > 0) {
                    int X = x;
                    int Y = y;
                    int Z = z;
                    int spawnAttempt = 4;
                    while (spawnAttempt-- > 0) {
                        float spawnZ;
                        float spawnY;
                        float spawnX;
                        float spawnDist;
                        float posZ;
                        float posY;
                        float posX;
                        if (!LavaMonsterSpawnEvent.canLavaMonsterSpawnAtLocation((World)world, new BlockPos(X += world.field_73012_v.nextInt(groupRadius) - world.field_73012_v.nextInt(groupRadius), Y += world.field_73012_v.nextInt(1) - world.field_73012_v.nextInt(1), Z += world.field_73012_v.nextInt(groupRadius) - world.field_73012_v.nextInt(groupRadius))) || world.func_217358_a((double)(posX = (float)X + 0.5f), (double)(posY = (float)Y), (double)(posZ = (float)Z + 0.5f), 24.0) || !((spawnDist = (spawnX = posX - (float)spawnCoords.func_177958_n()) * spawnX + (spawnY = posY - (float)spawnCoords.func_177956_o()) * spawnY + (spawnZ = posZ - (float)spawnCoords.func_177952_p()) * spawnZ) >= 576.0f)) continue;
                        LavaMonsterEntity lavaMonster = new LavaMonsterEntity(LavaEntityTypes.LAVA_MONSTER, (World)world);
                        lavaMonster.func_70012_b(posX, posY, posZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((MobEntity)lavaMonster, (IWorld)world, (double)posX, (double)posY, (double)posZ, null, (SpawnReason)SpawnReason.NATURAL);
                        if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !lavaMonster.getCanSpawnHere())) continue;
                        ++numberSpawned;
                        world.func_217376_c((Entity)lavaMonster);
                        if (ForgeEventFactory.doSpecialSpawn((MobEntity)lavaMonster, (World)world, (float)posX, (float)posY, (float)posZ, null, null)) continue block3;
                        lavaMonster.func_213386_a((IServerWorld)world, world.func_175649_E(new BlockPos((double)posX, (double)posY, (double)posZ)), SpawnReason.NATURAL, null, null);
                        continue block3;
                    }
                }
            }
        }
        return numberSpawned;
    }

    private BlockPos getRandomSpawningPointInChunk(World world, int chunkX, int chunkZ) {
        Chunk chunk = world.func_212866_a_(chunkX, chunkZ);
        int x = (chunkX << 4) + world.field_73012_v.nextInt(16);
        int z = (chunkZ << 4) + world.field_73012_v.nextInt(16);
        int y = world.field_73012_v.nextInt(chunk == null ? world.func_217301_I() : chunk.func_76625_h() + 16 - 1);
        return new BlockPos(x, y, z);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.world instanceof ServerWorld && event.world.func_82736_K().func_223586_b(GameRules.field_223601_d) && event.world.func_175659_aa() != Difficulty.PEACEFUL) {
            this.performSpawning((ServerWorld)event.world);
        }
    }

    public List<LavaMonsterEntity> getLavaMonsters(World world) {
        ArrayList list = Lists.newArrayList();
        Int2ObjectMap entById = (Int2ObjectMap)ObfuscationReflectionHelper.getPrivateValue(ServerWorld.class, (Object)((ServerWorld)world), (String)"field_217498_x");
        for (Entity entity : entById.values()) {
            if (!(entity instanceof LavaMonsterEntity) || !entity.func_70089_S()) continue;
            list.add((LavaMonsterEntity)entity);
        }
        return list;
    }
}

