/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.worldgen.jigsaw;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.legacy.structure_gel.worldgen.jigsaw.GelJigsawPiece;
import com.legacy.structure_gel.worldgen.jigsaw.JigsawRegistryHelper;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.feature.template.Template;

public class JigsawPoolBuilder {
    private final JigsawRegistryHelper jigsawRegistryHelper;
    private Map<ResourceLocation, Integer> names = ImmutableMap.of();
    private int weight = 1;
    private StructureProcessorList processors = ProcessorLists.field_244101_a;
    private boolean maintainWater = true;
    private JigsawPattern.PlacementBehaviour placementBehavior = JigsawPattern.PlacementBehaviour.RIGID;

    public JigsawPoolBuilder(JigsawRegistryHelper jigsawRegistryHelper) {
        this.jigsawRegistryHelper = jigsawRegistryHelper;
    }

    public JigsawPoolBuilder names(Map<String, Integer> nameMap) {
        HashMap<ResourceLocation, Integer> tempNames = new HashMap<ResourceLocation, Integer>();
        nameMap.forEach((s, i) -> tempNames.put(this.jigsawRegistryHelper.locatePiece((String)s), (Integer)i));
        return this.namesR(tempNames);
    }

    public JigsawPoolBuilder namesR(Map<ResourceLocation, Integer> nameMap) {
        this.names = nameMap;
        return this;
    }

    public JigsawPoolBuilder names(Collection<String> names) {
        HashMap<ResourceLocation, Integer> tempNames = new HashMap<ResourceLocation, Integer>();
        for (String s : names) {
            tempNames.put(this.jigsawRegistryHelper.locatePiece(s), this.weight);
        }
        return this.namesR(tempNames);
    }

    public JigsawPoolBuilder namesR(Collection<ResourceLocation> names) {
        HashMap<ResourceLocation, Integer> tempNames = new HashMap<ResourceLocation, Integer>();
        for (ResourceLocation rl : names) {
            tempNames.put(rl, this.weight);
        }
        return this.namesR(tempNames);
    }

    public JigsawPoolBuilder names(String ... names) {
        return this.names(Arrays.asList(names));
    }

    public JigsawPoolBuilder namesR(ResourceLocation ... names) {
        return this.namesR(Arrays.asList(names));
    }

    public JigsawPoolBuilder weight(int weight) {
        this.weight = weight;
        return this.namesR(this.names.keySet());
    }

    public JigsawPoolBuilder processors(StructureProcessorList processors) {
        this.processors = processors;
        return this;
    }

    public JigsawPoolBuilder maintainWater(boolean maintainWater) {
        this.maintainWater = maintainWater;
        return this;
    }

    public JigsawPoolBuilder placementBehavior(JigsawPattern.PlacementBehaviour placementBehavior) {
        this.placementBehavior = placementBehavior;
        return this;
    }

    public List<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> build() {
        ArrayList jigsawList = new ArrayList();
        this.names.forEach((rl, i) -> jigsawList.add(Pair.of(JigsawPoolBuilder.createGelPiece(rl, this.processors, this.maintainWater, false), (Object)i)));
        return (List)jigsawList.stream().collect(ImmutableList.toImmutableList());
    }

    public static List<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> build(Map<JigsawPiece, Integer> pieceMap) {
        ArrayList jigsawList = new ArrayList();
        pieceMap.forEach((jp, i) -> jigsawList.add(Pair.of(placement -> jp, (Object)i)));
        return (List)jigsawList.stream().collect(ImmutableList.toImmutableList());
    }

    public static List<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> build(JigsawPiece ... pieces) {
        ArrayList<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> pairs = new ArrayList<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>>();
        for (JigsawPiece p : pieces) {
            pairs.add((Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>)Pair.of(placement -> p, (Object)1));
        }
        return pairs;
    }

    public static List<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> collect(JigsawPoolBuilder ... builders) {
        return JigsawPoolBuilder.collect(Arrays.asList(builders));
    }

    public static List<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> collect(List<JigsawPoolBuilder> builders) {
        List<Object> pairs = new ArrayList<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>>();
        for (JigsawPoolBuilder builder : builders) {
            pairs = (List)Streams.concat((Stream[])new Stream[]{pairs.stream(), builder.build().stream()}).collect(ImmutableList.toImmutableList());
        }
        return pairs;
    }

    public JigsawPoolBuilder clone() {
        return new JigsawPoolBuilder(this.jigsawRegistryHelper).weight(this.weight).namesR(this.names).maintainWater(this.maintainWater).processors(this.processors).placementBehavior(this.placementBehavior);
    }

    public static Function<JigsawPattern.PlacementBehaviour, GelJigsawPiece> createGelPiece(ResourceLocation name, StructureProcessorList processors, boolean maintainWater, boolean ignoreEntities) {
        return placement -> new GelJigsawPiece((Either<ResourceLocation, Template>)Either.left((Object)name), () -> processors, (JigsawPattern.PlacementBehaviour)placement, maintainWater, ignoreEntities);
    }
}

