/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.legacy.structure_gel.registrars.IForgeRegistrar;
import com.legacy.structure_gel.registrars.IRegistrar;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHelper {
    public static <T> Optional<RegistryKey<T>> getKey(World world, RegistryKey<Registry<T>> registry, T value) {
        return world.func_241828_r().func_243612_b(registry).func_230519_c_(value);
    }

    public static <T> Optional<RegistryKey<T>> getKey(IWorld world, RegistryKey<Registry<T>> registry, T value) {
        return world.func_241828_r().func_243612_b(registry).func_230519_c_(value);
    }

    public static <T> Optional<T> getValue(World world, RegistryKey<Registry<T>> registry, RegistryKey<T> key) {
        return Optional.ofNullable(world.func_241828_r().func_243612_b(registry).func_230516_a_(key));
    }

    public static <T> Optional<T> getValue(IWorld world, RegistryKey<Registry<T>> registry, RegistryKey<T> key) {
        return Optional.ofNullable(world.func_241828_r().func_243612_b(registry).func_230516_a_(key));
    }

    @Deprecated
    public static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, ResourceLocation key, T registryObject) {
        return RegistryHelper.registerExact(registry, key, registryObject);
    }

    public static <T extends IForgeRegistryEntry<T>, C extends T> C registerExact(IForgeRegistry<T> registry, ResourceLocation key, C registryObject) {
        registryObject.setRegistryName(key);
        registry.register(registryObject);
        return registryObject;
    }

    public static PointOfInterestType registerPOI(IForgeRegistry<PointOfInterestType> registry, PointOfInterestType poi) {
        PointOfInterestType.func_221052_a((PointOfInterestType)poi);
        return RegistryHelper.register(registry, new ResourceLocation(poi.toString()), poi);
    }

    public static <FC extends IFeatureConfig, F extends Feature<FC>> ConfiguredFeature<FC, F> registerConfiguredFeature(ResourceLocation key, ConfiguredFeature<FC, F> configuredFeature) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)key, configuredFeature);
    }

    public static <C extends IFeatureConfig, S extends Structure<C>> S registerStructure(IForgeRegistry<Structure<?>> registry, ResourceLocation key, S structure, GenerationStage.Decoration generationStage) {
        structure.setRegistryName(key);
        registry.register(structure);
        Structure.field_236365_a_.put((Object)key.toString(), structure);
        Structure.field_236385_u_.put(structure, generationStage);
        return structure;
    }

    public static <P extends IStructurePieceType> P registerStructurePiece(ResourceLocation key, P pieceType) {
        return (P)((IStructurePieceType)Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)key, pieceType));
    }

    @Deprecated
    public static <C extends IFeatureConfig, S extends Structure<C>, P extends IStructurePieceType> Pair<S, P> registerStructureAndPiece(IForgeRegistry<Structure<?>> registry, ResourceLocation key, S structure, GenerationStage.Decoration generationStage, P pieceType) {
        S struc = RegistryHelper.registerStructure(registry, key, structure, generationStage);
        P piece = RegistryHelper.registerStructurePiece(key, pieceType);
        return Pair.of(struc, piece);
    }

    public static <C extends IFeatureConfig, S extends Structure<C>, SF extends StructureFeature<C, S>> SF registerStructureFeature(ResourceLocation key, SF structureFeature) {
        return (SF)((StructureFeature)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)key, structureFeature));
    }

    public static <C extends IFeatureConfig, S extends Structure<C>, SF extends StructureFeature<C, S>> SF registerStructureFeature(SF structureFeature) {
        return RegistryHelper.registerStructureFeature(structureFeature.field_236268_b_.getRegistryName(), structureFeature);
    }

    public static <R extends IRegistrar<R>> R handleRegistrar(R registrar) {
        return registrar.handle();
    }

    public static <R extends IForgeRegistrar<R, V>, V extends IForgeRegistryEntry<V>> R handleRegistrar(R registrar, IForgeRegistry<V> registry) {
        return registrar.handleForge(registry);
    }

    public static StructureProcessorList registerProcessor(ResourceLocation key, StructureProcessor processor) {
        return (StructureProcessorList)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243655_g, (ResourceLocation)key, (Object)new StructureProcessorList((List)ImmutableList.of((Object)processor)));
    }

    public static StructureProcessorList registerProcessor(ResourceLocation key, StructureProcessorList processorList) {
        return (StructureProcessorList)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243655_g, (ResourceLocation)key, (Object)processorList);
    }

    public static StructureProcessorList registerProcessor(ResourceLocation key, List<StructureProcessor> processors) {
        return (StructureProcessorList)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243655_g, (ResourceLocation)key, (Object)new StructureProcessorList(processors));
    }

    public static StructureProcessorList combineProcessors(StructureProcessorList ... lists) {
        ArrayList processors = new ArrayList();
        Arrays.asList(lists).forEach(spl -> processors.addAll(spl.func_242919_a()));
        return new StructureProcessorList(processors);
    }

    public static StructureProcessorList combineProcessors(StructureProcessorList list, List<StructureProcessor> processors) {
        return new StructureProcessorList((List)Streams.concat((Stream[])new Stream[]{list.func_242919_a().stream(), processors.stream()}).collect(ImmutableList.toImmutableList()));
    }
}

