/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.util;

import com.legacy.structure_gel.blocks.GelPortalBlock;
import com.legacy.structure_gel.util.Internal;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.PortalInfo;
import net.minecraft.block.PortalSize;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class GelTeleporter
extends Teleporter {
    private final Supplier<RegistryKey<World>> dimension1;
    private final Supplier<RegistryKey<World>> dimension2;
    private final Supplier<PointOfInterestType> portalPOI;
    private final Supplier<GelPortalBlock> portalBlock;
    private final Supplier<BlockState> frameBlock;
    private final ICreatePortalFuncion placementBehavior;

    public GelTeleporter(ServerWorld world, Supplier<RegistryKey<World>> dimension1, Supplier<RegistryKey<World>> dimension2, Supplier<PointOfInterestType> portalPOI, Supplier<GelPortalBlock> portalBlock, Supplier<BlockState> frameBlock, ICreatePortalFuncion placementBehavior) {
        super(world);
        this.dimension1 = dimension1;
        this.dimension2 = dimension2;
        this.portalPOI = portalPOI;
        this.portalBlock = portalBlock;
        this.frameBlock = frameBlock;
        this.placementBehavior = placementBehavior;
    }

    public GelTeleporter(ServerWorld worldIn, Supplier<RegistryKey<World>> dimension1, Supplier<RegistryKey<World>> dimension2, Supplier<PointOfInterestType> portalPOI, Supplier<GelPortalBlock> portalBlock, Supplier<BlockState> frameBlock, CreatePortalBehavior placementBehavior) {
        this(worldIn, dimension1, dimension2, portalPOI, portalBlock, frameBlock, placementBehavior.get());
    }

    @Internal
    public RegistryKey<World> getOpposite() {
        if (this.field_85192_a != null && this.field_85192_a.func_234923_W_().func_240901_a_().equals((Object)this.dimension1.get().func_240901_a_())) {
            return this.dimension2.get();
        }
        return this.dimension1.get();
    }

    public Supplier<RegistryKey<World>> getDimension1() {
        return this.dimension1;
    }

    public Supplier<RegistryKey<World>> getDimension2() {
        return this.dimension2;
    }

    public Supplier<PointOfInterestType> getPortalPOI() {
        return this.portalPOI;
    }

    public Supplier<GelPortalBlock> getPortalBlock() {
        return this.portalBlock;
    }

    public Supplier<BlockState> getFrameBlock() {
        return this.frameBlock;
    }

    public ICreatePortalFuncion getPlacementBehavior() {
        return this.placementBehavior;
    }

    public ServerWorld getWorld() {
        return this.field_85192_a;
    }

    public boolean shouldIgnoreBlock(BlockState state, BlockPos pos) {
        return state.func_235714_a_((ITag)BlockTags.field_206952_E) || state.func_235714_a_((ITag)BlockTags.field_200031_h) || state.isAir((IBlockReader)this.field_85192_a, pos) || state.func_196952_d((IBlockReader)this.field_85192_a, pos).func_197766_b() && !state.func_185904_a().func_76224_d();
    }

    public int getDefaultHeight() {
        return 70;
    }

    public Optional<TeleportationRepositioner.Result> func_242957_a(BlockPos startPos, boolean toNether) {
        PointOfInterestManager poiManager = this.field_85192_a.func_217443_B();
        int dist = (int)Math.max(DimensionType.func_242715_a((DimensionType)this.field_85192_a.func_73046_m().func_71218_a(this.getOpposite()).func_230315_m_(), (DimensionType)this.field_85192_a.func_230315_m_()) * 16.0, 16.0);
        poiManager.func_226347_a_((IWorldReader)this.field_85192_a, startPos, dist);
        Optional<PointOfInterest> optional = poiManager.func_226353_b_(poiType -> poiType == this.portalPOI.get(), startPos, dist, PointOfInterestManager.Status.ANY).filter(poi -> poiManager.func_219148_c(poi.func_218261_f().func_177977_b()).orElse(null) != poi.func_218260_g()).filter(poi -> this.field_85192_a.func_180495_p(poi.func_218261_f()).func_235901_b_((Property)BlockStateProperties.field_208199_z)).min(Comparator.comparingDouble(poi -> poi.func_218261_f().func_177951_i((Vector3i)startPos)).thenComparingInt(poi -> poi.func_218261_f().func_177956_o()));
        return optional.map(poi -> {
            BlockPos blockpos = poi.func_218261_f();
            this.field_85192_a.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(blockpos), 3, (Object)blockpos);
            BlockState blockstate = this.field_85192_a.func_180495_p(blockpos);
            return TeleportationRepositioner.func_243676_a((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.func_177229_b((Property)BlockStateProperties.field_208199_z)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> this.field_85192_a.func_180495_p(pos) == blockstate);
        });
    }

    public Optional<TeleportationRepositioner.Result> func_242956_a(BlockPos startPos, Direction.Axis enterAxis) {
        return this.placementBehavior.apply(this, startPos, enterAxis);
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
        Vector3d offset;
        Direction.Axis portalAxis;
        WorldBorder worldborder = destWorld.func_175723_af();
        double minX = Math.max(-2.9999872E7, worldborder.func_177726_b() + 16.0);
        double minZ = Math.max(-2.9999872E7, worldborder.func_177736_c() + 16.0);
        double maxX = Math.min(2.9999872E7, worldborder.func_177728_d() - 16.0);
        double maxZ = Math.min(2.9999872E7, worldborder.func_177733_e() - 16.0);
        double scaling = DimensionType.func_242715_a((DimensionType)entity.field_70170_p.func_230315_m_(), (DimensionType)destWorld.func_230315_m_());
        BlockPos scaledPos = new BlockPos(MathHelper.func_151237_a((double)(entity.func_226277_ct_() * scaling), (double)minX, (double)maxX), entity.func_226278_cu_(), MathHelper.func_151237_a((double)(entity.func_226281_cx_() * scaling), (double)minZ, (double)maxZ));
        BlockPos portalPos = (BlockPos)ObfuscationReflectionHelper.getPrivateValue(Entity.class, (Object)entity, (String)"field_242271_ac");
        BlockState blockstate = entity.field_70170_p.func_180495_p(portalPos);
        if (blockstate.func_235901_b_((Property)BlockStateProperties.field_208199_z)) {
            portalAxis = (Direction.Axis)blockstate.func_177229_b((Property)BlockStateProperties.field_208199_z);
            TeleportationRepositioner.Result motionTpResult = TeleportationRepositioner.func_243676_a((BlockPos)portalPos, (Direction.Axis)portalAxis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, bp -> entity.field_70170_p.func_180495_p(bp) == blockstate);
            offset = PortalSize.func_242973_a((TeleportationRepositioner.Result)motionTpResult, (Direction.Axis)portalAxis, (Vector3d)entity.func_213303_ch(), (EntitySize)entity.func_213305_a(entity.func_213283_Z()));
        } else {
            portalAxis = Direction.Axis.X;
            offset = new Vector3d(0.5, 0.0, 0.0);
        }
        Optional<TeleportationRepositioner.Result> result = this.func_242957_a(scaledPos, false);
        if (entity instanceof ServerPlayerEntity && !result.isPresent()) {
            result = this.func_242956_a(scaledPos, portalAxis);
        }
        if (!result.isPresent()) {
            return null;
        }
        PortalInfo portalInfo = PortalSize.func_242963_a((ServerWorld)destWorld, (TeleportationRepositioner.Result)result.get(), (Direction.Axis)portalAxis, (Vector3d)offset, (EntitySize)entity.func_213305_a(entity.func_213283_Z()), (Vector3d)entity.func_213322_ci(), (float)entity.field_70177_z, (float)entity.field_70125_A);
        return new PortalInfo(new Vector3d((double)result.get().field_243679_a.func_177958_n() + 0.5, (double)result.get().field_243679_a.func_177956_o() + 0.05, (double)result.get().field_243679_a.func_177952_p() + 0.5), portalInfo.field_222506_b, portalInfo.field_242960_c, portalInfo.field_242961_d);
    }

    public static Optional<TeleportationRepositioner.Result> createAndFindPortalSurface(GelTeleporter teleporter, BlockPos startPos, Direction.Axis enterAxis) {
        int x1;
        int i;
        ServerWorld world = teleporter.field_85192_a;
        int x = startPos.func_177958_n();
        int y = world.func_234938_ad_();
        int z = startPos.func_177952_p();
        BlockPos.Mutable mutablePos = new BlockPos.Mutable(x, y, z);
        BlockState state = world.func_180495_p((BlockPos)mutablePos);
        for (i = y; i > 0 && teleporter.shouldIgnoreBlock(state, (BlockPos)mutablePos); --i) {
            state = world.func_180495_p((BlockPos)mutablePos.func_189536_c(Direction.DOWN));
        }
        y = i <= 0 ? teleporter.getDefaultHeight() : i + 1;
        BlockState frameState = teleporter.getFrameBlock().get();
        for (int horizontalOffset = -1; horizontalOffset < 3; ++horizontalOffset) {
            for (int verticalOffset = -1; verticalOffset < 4; ++verticalOffset) {
                if (horizontalOffset != -1 && horizontalOffset != 2 && verticalOffset != -1 && verticalOffset != 3) continue;
                BlockPos pos2 = new BlockPos(x, y + verticalOffset, z + horizontalOffset);
                world.func_180501_a(pos2, frameState, 3);
            }
        }
        BlockState portalState = (BlockState)teleporter.getPortalBlock().get().func_176223_P().func_206870_a((Property)NetherPortalBlock.field_176550_a, (Comparable)Direction.Axis.Z);
        for (int horizontalOffset = 0; horizontalOffset < 2; ++horizontalOffset) {
            for (int verticalOffset = 0; verticalOffset < 3; ++verticalOffset) {
                BlockPos pos2 = new BlockPos(x, y + verticalOffset, z + horizontalOffset);
                world.func_180501_a(pos2, portalState, 18);
            }
        }
        boolean placePlatform = true;
        block5: for (x1 = -1; x1 < 2; ++x1) {
            for (int z1 = 0; z1 < 2; ++z1) {
                BlockPos pos2 = new BlockPos(x + x1, y - 1, z + z1);
                BlockState existingState = world.func_180495_p(pos2);
                if (teleporter.shouldIgnoreBlock(existingState, pos2) || existingState.func_185904_a().func_76224_d() || existingState.func_177230_c() == frameState.func_177230_c()) continue;
                placePlatform = false;
                break block5;
            }
        }
        if (placePlatform) {
            for (x1 = -1; x1 < 2; ++x1) {
                for (int z1 = 0; z1 < 2; ++z1) {
                    world.func_175656_a(new BlockPos(x + x1, y - 1, z + z1), frameState);
                }
            }
        }
        return teleporter.func_242957_a(startPos, false);
    }

    public static Optional<TeleportationRepositioner.Result> createAndFindPortalNether(GelTeleporter teleporter, BlockPos startPos, Direction.Axis enterAxis) {
        Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)enterAxis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = teleporter.field_85192_a.func_175723_af();
        int i = teleporter.field_85192_a.func_234938_ad_() - 1;
        BlockPos.Mutable blockpos$mutable = startPos.func_239590_i_();
        for (BlockPos.Mutable blockpos$mutable1 : BlockPos.func_243514_a((BlockPos)startPos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(i, teleporter.field_85192_a.func_201676_a(Heightmap.Type.MOTION_BLOCKING, blockpos$mutable1.func_177958_n(), blockpos$mutable1.func_177952_p()));
            if (!worldborder.func_177746_a((BlockPos)blockpos$mutable1) || !worldborder.func_177746_a((BlockPos)blockpos$mutable1.func_189534_c(direction, 1))) continue;
            blockpos$mutable1.func_189534_c(direction.func_176734_d(), 1);
            for (int l = j; l >= 0; --l) {
                int j1;
                blockpos$mutable1.func_185336_p(l);
                if (!teleporter.field_85192_a.func_175623_d((BlockPos)blockpos$mutable1)) continue;
                int i1 = l;
                while (l > 0 && teleporter.field_85192_a.func_175623_d((BlockPos)blockpos$mutable1.func_189536_c(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                blockpos$mutable1.func_185336_p(l);
                if (!teleporter.checkRegionForPlacement((BlockPos)blockpos$mutable1, blockpos$mutable, direction, 0)) continue;
                double d2 = startPos.func_177951_i((Vector3i)blockpos$mutable1);
                if (teleporter.checkRegionForPlacement((BlockPos)blockpos$mutable1, blockpos$mutable, direction, -1) && teleporter.checkRegionForPlacement((BlockPos)blockpos$mutable1, blockpos$mutable, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = blockpos$mutable1.func_185334_h();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = blockpos$mutable1.func_185334_h();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            blockpos = new BlockPos(startPos.func_177958_n(), MathHelper.func_76125_a((int)startPos.func_177956_o(), (int)70, (int)(teleporter.field_85192_a.func_234938_ad_() - 10)), startPos.func_177952_p()).func_185334_h();
            Direction direction1 = direction.func_176746_e();
            if (!worldborder.func_177746_a(blockpos)) {
                return Optional.empty();
            }
            for (int l1 = -1; l1 < 2; ++l1) {
                for (int k2 = 0; k2 < 2; ++k2) {
                    for (int i3 = -1; i3 < 3; ++i3) {
                        BlockState blockstate1 = i3 < 0 ? teleporter.frameBlock.get() : Blocks.field_150350_a.func_176223_P();
                        blockpos$mutable.func_239621_a_((Vector3i)blockpos, k2 * direction.func_82601_c() + l1 * direction1.func_82601_c(), i3, k2 * direction.func_82599_e() + l1 * direction1.func_82599_e());
                        teleporter.field_85192_a.func_175656_a((BlockPos)blockpos$mutable, blockstate1);
                    }
                }
            }
        }
        for (int k1 = -1; k1 < 3; ++k1) {
            for (int i2 = -1; i2 < 4; ++i2) {
                if (k1 != -1 && k1 != 2 && i2 != -1 && i2 != 3) continue;
                blockpos$mutable.func_239621_a_((Vector3i)blockpos, k1 * direction.func_82601_c(), i2, k1 * direction.func_82599_e());
                teleporter.field_85192_a.func_180501_a((BlockPos)blockpos$mutable, teleporter.frameBlock.get(), 3);
            }
        }
        BlockState blockstate = (BlockState)teleporter.portalBlock.get().func_176223_P().func_206870_a((Property)NetherPortalBlock.field_176550_a, (Comparable)enterAxis);
        for (int j2 = 0; j2 < 2; ++j2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                blockpos$mutable.func_239621_a_((Vector3i)blockpos, j2 * direction.func_82601_c(), l2, j2 * direction.func_82599_e());
                teleporter.field_85192_a.func_180501_a((BlockPos)blockpos$mutable, blockstate, 18);
            }
        }
        return Optional.of(new TeleportationRepositioner.Result(blockpos.func_185334_h(), 2, 3));
    }

    private boolean checkRegionForPlacement(BlockPos pos, BlockPos.Mutable mutablePos, Direction facing, int offset) {
        Direction direction = facing.func_176746_e();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                mutablePos.func_239621_a_((Vector3i)pos, facing.func_82601_c() * i + direction.func_82601_c() * offset, j, facing.func_82599_e() * i + direction.func_82599_e() * offset);
                if (j < 0 && !this.field_85192_a.func_180495_p((BlockPos)mutablePos).func_185904_a().func_76220_a()) {
                    return false;
                }
                if (j < 0 || this.field_85192_a.func_175623_d((BlockPos)mutablePos)) continue;
                return false;
            }
        }
        return true;
    }

    @FunctionalInterface
    public static interface ICreatePortalFuncion {
        public Optional<TeleportationRepositioner.Result> apply(GelTeleporter var1, BlockPos var2, Direction.Axis var3);
    }

    public static enum CreatePortalBehavior {
        NETHER(GelTeleporter::createAndFindPortalNether),
        ON_SURFACE(GelTeleporter::createAndFindPortalSurface);

        private final ICreatePortalFuncion function;

        private CreatePortalBehavior(ICreatePortalFuncion function) {
            this.function = function;
        }

        public ICreatePortalFuncion get() {
            return this.function;
        }
    }
}

