/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.util;

import com.legacy.structure_gel.blocks.GelPortalBlock;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class GelPortalSize {
    public final Block frame;
    public final GelPortalBlock portal;
    public final IWorld world;
    public final Direction.Axis axis;
    public final Direction rightDir;
    public final Direction leftDir;
    public int portalBlockCount;
    @Nullable
    public BlockPos bottomLeft;
    public int height;
    public int width;
    public List<Block> allowedBlocks = new ArrayList<Block>();

    public GelPortalSize(IWorld world, BlockPos pos, Direction.Axis axis, Block frame, GelPortalBlock portal, List<Block> allowedBlocks) {
        this.world = world;
        this.axis = axis;
        this.frame = frame;
        this.portal = portal;
        this.allowedBlocks = allowedBlocks;
        if (axis == Direction.Axis.X) {
            this.leftDir = Direction.EAST;
            this.rightDir = Direction.WEST;
        } else {
            this.leftDir = Direction.NORTH;
            this.rightDir = Direction.SOUTH;
        }
        BlockPos blockpos = pos;
        while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.isValidInsideMaterial(world.func_180495_p(pos.func_177977_b()))) {
            pos = pos.func_177977_b();
        }
        int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
        if (i >= 0) {
            this.bottomLeft = pos.func_177967_a(this.leftDir, i);
            this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
            if (this.width < 2 || this.width > 21) {
                this.bottomLeft = null;
                this.width = 0;
            }
        }
        if (this.bottomLeft != null) {
            this.height = this.calculatePortalHeight();
        }
    }

    public static boolean trySpawnPortal(IWorld worldIn, BlockPos pos, GelPortalBlock portalBlock, List<Block> allowedBlocks) {
        Block frameBlock = portalBlock.getFrameBlock().get().func_177230_c();
        GelPortalSize sizeX = new GelPortalSize(worldIn, pos, Direction.Axis.X, frameBlock, portalBlock, allowedBlocks);
        if (sizeX.isValidSize() && sizeX.portalBlockCount == 0) {
            sizeX.placePortalBlocks();
            return true;
        }
        GelPortalSize sizeZ = new GelPortalSize(worldIn, pos, Direction.Axis.Z, frameBlock, portalBlock, allowedBlocks);
        if (sizeZ.isValidSize() && sizeZ.portalBlockCount == 0) {
            sizeZ.placePortalBlocks();
            return true;
        }
        return false;
    }

    public static boolean isPortal(World worldIn, BlockPos pos, GelPortalBlock portalBlock, List<Block> allowedInsideBlocks) {
        GelPortalSize sizeX = new GelPortalSize((IWorld)worldIn, pos, Direction.Axis.X, portalBlock.getFrameBlock().get().func_177230_c(), portalBlock, allowedInsideBlocks);
        if (sizeX.isValidSize()) {
            return true;
        }
        GelPortalSize sizeZ = new GelPortalSize((IWorld)worldIn, pos, Direction.Axis.Z, portalBlock.getFrameBlock().get().func_177230_c(), portalBlock, allowedInsideBlocks);
        return sizeZ.isValidSize();
    }

    public boolean isValidSize() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public boolean isPortalComplete() {
        return this.isValidSize() && this.hasAllPortals();
    }

    public boolean hasAllPortals() {
        return this.portalBlockCount >= this.width * this.height;
    }

    protected int getDistanceUntilEdge(BlockPos pos, Direction direction) {
        BlockPos blockpos;
        int i;
        for (i = 0; i < 22 && this.isValidInsideMaterial(this.world.func_180495_p(blockpos = pos.func_177967_a(direction, i))) && this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == this.frame; ++i) {
        }
        Block block = this.world.func_180495_p(pos.func_177967_a(direction, i)).func_177230_c();
        return block == this.frame ? i : 0;
    }

    protected int calculatePortalHeight() {
        this.height = 0;
        block0: while (this.height < 21) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                BlockState blockstate = this.world.func_180495_p(blockpos);
                if (!this.isValidInsideMaterial(blockstate)) break block0;
                Block block = blockstate.func_177230_c();
                if (block == this.portal) {
                    ++this.portalBlockCount;
                }
                if (i == 0 ? (block = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir)).func_177230_c()) != this.frame : i == this.width - 1 && (block = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir)).func_177230_c()) != this.frame) break block0;
            }
            ++this.height;
        }
        for (int j = 0; j < this.width; ++j) {
            if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)).func_177230_c() == this.frame) continue;
            this.height = 0;
            break;
        }
        if (this.height <= 21 && this.height >= 3) {
            return this.height;
        }
        this.bottomLeft = null;
        this.width = 0;
        this.height = 0;
        return 0;
    }

    protected boolean isValidInsideMaterial(BlockState state) {
        Block block = state.func_177230_c();
        return state.func_185904_a() == Material.field_151579_a || block == this.portal || this.allowedBlocks.contains(block);
    }

    public void placePortalBlocks() {
        for (int i = 0; i < this.width; ++i) {
            BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
            for (int j = 0; j < this.height; ++j) {
                this.world.func_180501_a(blockpos.func_177981_b(j), (BlockState)this.portal.func_176223_P().func_206870_a((Property)NetherPortalBlock.field_176550_a, (Comparable)this.axis), 18);
            }
        }
    }
}

