/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.util;

import com.legacy.structure_gel.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.util.Internal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigTemplates {

    @Deprecated
    public static class BiomeStructureConfig
    extends StructureConfig {
        public BiomeStructureConfig(ForgeConfigSpec.Builder builder, String name, double probability, int spacing, int offset, String biomes, boolean isWhitelist) {
            super(builder, name, probability, spacing, offset);
            this.biomes(isWhitelist, biomes);
        }

        public BiomeStructureConfig(ForgeConfigSpec.Builder builder, String name, double probability, int spacing, int offset, String biomes) {
            this(builder, name, probability, spacing, offset, biomes, true);
        }
    }

    public static class StructureConfig {
        private final ForgeConfigSpec.Builder builder;
        private final String name;
        private ForgeConfigSpec.DoubleValue probability;
        private ForgeConfigSpec.IntValue spacing;
        private ForgeConfigSpec.IntValue offset;
        private ForgeConfigSpec.BooleanValue isWhitelist;
        private ForgeConfigSpec.ConfigValue<String> biomeString;
        private List<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
        private Map<EntityClassification, ForgeConfigSpec.ConfigValue<String>> spawnsStrings = new HashMap<EntityClassification, ForgeConfigSpec.ConfigValue<String>>();
        private Map<EntityClassification, List<MobSpawnInfo.Spawners>> spawns = new HashMap<EntityClassification, List<MobSpawnInfo.Spawners>>();
        private ForgeConfigSpec.ConfigValue<String> noiseSettingsString;
        @Nullable
        private List<DimensionSettings> noiseSettings = null;

        public StructureConfig(ForgeConfigSpec.Builder builder, String name) {
            this.builder = builder;
            this.name = name;
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLoad);
        }

        public StructureConfig(ForgeConfigSpec.Builder builder, String name, double probability, int spacing, int offset) {
            this(builder, name);
            this.probability(probability).spacing(spacing).offset(offset);
        }

        public StructureConfig probability(double probability) {
            this.probability = this.builder.comment("Chance of generating in an allowed chunk").defineInRange(this.name + ".probability", probability, 0.0, 1.0);
            return this;
        }

        public StructureConfig spacing(int spacing) {
            this.spacing = this.builder.comment("Spacing between structures").defineInRange(this.name + ".spacing", spacing, 1, Integer.MAX_VALUE);
            return this;
        }

        public StructureConfig offset(int offset) {
            this.offset = this.builder.comment("Offsets the spacing of the structures randomly").defineInRange(this.name + ".offset", offset, 0, Integer.MAX_VALUE);
            return this;
        }

        public StructureConfig biomes(boolean isWhitelist, String biomes) {
            this.biomeString = this.builder.comment("A biome filter to determine where the structure should generate. Works with the biome dictionary (#overworld) and \"not\" statements (!plains). These can be combined (!#nether). Operates in the order presented. So \"#forest, !flower_forest\" will add all forests and then remove the flower forest.").define(this.name + ".biomes", (Object)biomes);
            this.isWhitelist = this.builder.comment("How should the code treate biomes? true = whitelist, false = blacklist. Biomes defined with ! do the opposite.").define(this.name + ".is_whitelist", isWhitelist);
            return this;
        }

        public StructureConfig spawns(Map<EntityClassification, String> spawns) {
            for (EntityClassification classification : EntityClassification.values()) {
                if (!spawns.containsKey(classification)) continue;
                this.getSpawnsStrings().put(classification, (ForgeConfigSpec.ConfigValue<String>)this.builder.define(this.name + ".spawns." + classification.func_220363_a(), (Object)spawns.get(classification)));
            }
            return this;
        }

        public StructureConfig noiseSettings(String noiseSettings) {
            this.noiseSettingsString = this.builder.comment("What dimension noise settings should this structure be placed in. Default options are \"overworld\", \"amplified\", \"end\", \"nether\", \"caves\", and \"floating_islands\"").define(this.name + ".noise_settings", (Object)noiseSettings);
            return this;
        }

        public StructureConfig noiseSettings(DimensionSettings ... noiseSettings) {
            String string = "";
            for (int i = 0; i < noiseSettings.length; ++i) {
                string = string + WorldGenRegistries.field_243658_j.func_177774_c((Object)noiseSettings[i]).toString();
                if (i >= noiseSettings.length - 1) continue;
                string = string + ", ";
            }
            return this.noiseSettings(string);
        }

        public double getProbability() {
            return this.probability != null ? (Double)this.probability.get() : 1.0;
        }

        public int getSpacing() {
            return this.spacing != null ? (Integer)this.spacing.get() : 16;
        }

        public int getOffset() {
            return this.offset != null ? (Integer)this.offset.get() : 7;
        }

        public boolean isWhitelist() {
            return this.isWhitelist != null ? (Boolean)this.isWhitelist.get() : true;
        }

        public String getBiomeString() {
            return this.biomeString != null ? (String)this.biomeString.get() : "";
        }

        public List<ResourceLocation> getBiomes() {
            return this.biomes;
        }

        public Map<EntityClassification, ForgeConfigSpec.ConfigValue<String>> getSpawnsStrings() {
            return this.spawnsStrings != null ? this.spawnsStrings : new HashMap<EntityClassification, ForgeConfigSpec.ConfigValue<String>>();
        }

        public String getSpawnsString(EntityClassification classification) {
            return this.getSpawnsStrings().containsKey(classification) ? (String)this.getSpawnsStrings().get(classification).get() : "";
        }

        @Nullable
        public List<MobSpawnInfo.Spawners> getSpawnsForClassification(EntityClassification classification) {
            return this.getSpawns().get(classification);
        }

        public Map<EntityClassification, List<MobSpawnInfo.Spawners>> getSpawns() {
            return this.spawns;
        }

        @Nullable
        public String getNoiseSettingsString() {
            return this.noiseSettingsString != null ? (String)this.noiseSettingsString.get() : null;
        }

        @Nullable
        public List<DimensionSettings> getNoiseSettings() {
            return this.noiseSettings;
        }

        protected void onConfigLoad(ModConfig.ModConfigEvent event) {
            this.spawns = new HashMap<EntityClassification, List<MobSpawnInfo.Spawners>>(){
                private static final long serialVersionUID = 64168135463438L;
                {
                    for (EntityClassification EC : EntityClassification.values()) {
                        if (this.getSpawnsString(EC).isEmpty()) continue;
                        this.put(EC, this.parseSpawns(this.getSpawnsString(EC)));
                    }
                }
            };
            this.biomes = this.parseBiomes(this.getBiomeString());
            this.noiseSettings = this.parseNoiseSettings(this.getNoiseSettingsString());
        }

        public boolean isBiomeAllowed(Biome biome) {
            return this.isBiomeAllowed(biome.getRegistryName());
        }

        public boolean isBiomeAllowed(RegistryKey<Biome> biome) {
            return this.isBiomeAllowed(biome.func_240901_a_());
        }

        public boolean isBiomeAllowed(ResourceLocation biome) {
            return this.biomes.contains(biome) == this.isWhitelist();
        }

        public List<ResourceLocation> parseBiomes(String key) {
            ArrayList<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
            if (!key.isEmpty()) {
                Arrays.asList(key.replace(" ", "").split(",")).stream().forEach(s -> {
                    boolean not = s.startsWith("!");
                    boolean isTag = s.replace("!", "").startsWith("#");
                    String biomeString = s.replace("!", "").replace("#", "");
                    ResourceLocation value = new ResourceLocation(biomeString);
                    if (!isTag) {
                        StructureConfig.updateBiomeList(biomes, value, not);
                    } else if (BiomeDictionary.contains(value)) {
                        BiomeDictionary.get(value).getAllBiomes().forEach(b -> StructureConfig.updateBiomeList(biomes, b.func_240901_a_(), not));
                    }
                });
            }
            return biomes;
        }

        @Internal
        protected static void updateBiomeList(List<ResourceLocation> biomes, ResourceLocation biome, boolean not) {
            if (not) {
                if (biomes.contains(biome)) {
                    biomes.remove(biome);
                }
            } else if (!biomes.contains(biome)) {
                biomes.add(biome);
            }
        }

        public List<MobSpawnInfo.Spawners> parseSpawns(String key) {
            ArrayList<MobSpawnInfo.Spawners> spawns = new ArrayList<MobSpawnInfo.Spawners>();
            if (!key.isEmpty()) {
                try {
                    Matcher matcher = Pattern.compile("(\\[([a-z0-9/_:[-][.]]*),\\s*([0-9]*),\\s*([0-9]*),\\s*([0-9*])\\])").matcher(key);
                    while (matcher.find()) {
                        ResourceLocation entity = new ResourceLocation(matcher.group(2));
                        if (!ForgeRegistries.ENTITIES.containsKey(entity)) continue;
                        spawns.add(new MobSpawnInfo.Spawners((EntityType)ForgeRegistries.ENTITIES.getValue(entity), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5))));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return spawns;
        }

        @Nullable
        public List<DimensionSettings> parseNoiseSettings(String key) {
            if (key == null) {
                return null;
            }
            ArrayList<DimensionSettings> noiseSettings = new ArrayList<DimensionSettings>();
            if (!key.isEmpty()) {
                Arrays.asList(key.replace(" ", "").split(",")).stream().forEach(s -> {
                    ResourceLocation settings = new ResourceLocation(s);
                    if (WorldGenRegistries.field_243658_j.func_241873_b(settings).isPresent()) {
                        noiseSettings.add((DimensionSettings)WorldGenRegistries.field_243658_j.func_241873_b(settings).get());
                    }
                });
            }
            return noiseSettings;
        }
    }
}

