/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.packets;

import com.legacy.structure_gel.blocks.GelPortalBlock;
import com.legacy.structure_gel.util.Internal;
import com.legacy.structure_gel.util.capability.GelCapability;
import com.legacy.structure_gel.util.capability.GelEntity;
import com.legacy.structure_gel.util.capability.IGelEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class UpdateGelPlayerPacket {
    protected final IGelEntity gelEntity;

    public UpdateGelPlayerPacket(IGelEntity gelEntity) {
        this.gelEntity = gelEntity;
    }

    public static void encoder(UpdateGelPlayerPacket packet, PacketBuffer buff) {
        UpdateGelPlayerPacket.putPortal(buff, packet.gelEntity.getPortal());
        UpdateGelPlayerPacket.putPortal(buff, packet.gelEntity.getPortalVisual());
        UpdateGelPlayerPacket.putPortal(buff, packet.gelEntity.getPortalAudio());
    }

    public static UpdateGelPlayerPacket decoder(PacketBuffer buff) {
        GelEntity gelEntity = new GelEntity();
        gelEntity.setPortal(UpdateGelPlayerPacket.getPortal(buff));
        gelEntity.setPortalVisual(UpdateGelPlayerPacket.getPortal(buff));
        gelEntity.setPortalAudio(UpdateGelPlayerPacket.getPortal(buff));
        return new UpdateGelPlayerPacket(gelEntity);
    }

    @Internal
    private static void putPortal(PacketBuffer buff, GelPortalBlock portal) {
        buff.func_180714_a(portal != null ? portal.getRegistryName().toString() : GelCapability.Storage.EMPTY.toString());
    }

    @Internal
    private static GelPortalBlock getPortal(PacketBuffer buff) {
        ResourceLocation portal = new ResourceLocation(buff.func_218666_n());
        return !portal.equals((Object)GelCapability.Storage.EMPTY) && ForgeRegistries.BLOCKS.containsKey(portal) && ForgeRegistries.BLOCKS.getValue(portal) instanceof GelPortalBlock ? (GelPortalBlock)ForgeRegistries.BLOCKS.getValue(portal) : null;
    }

    public static void handler(UpdateGelPlayerPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UpdateGelPlayerPacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(UpdateGelPlayerPacket packet) {
        Minecraft mc = Minecraft.func_71410_x();
        GelCapability.ifPresent(mc.field_71439_g, ge -> {
            ge.setPortal(packet.gelEntity.getPortal());
            ge.setPortalVisual(packet.gelEntity.getPortalVisual());
            ge.setPortalAudio(packet.gelEntity.getPortalAudio());
        });
    }
}

