/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.biome_dictionary;

import com.google.common.collect.Sets;
import com.legacy.structure_gel.biome_dictionary.BiomeType;
import com.legacy.structure_gel.util.Internal;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Internal
public class ForgeType
extends BiomeType {
    private final BiomeDictionary.Type type;

    private ForgeType(BiomeDictionary.Type type) {
        super(new ResourceLocation("forge", type.getName().toLowerCase()), Sets.newHashSet(), Sets.newHashSet());
        this.type = type;
    }

    public static ForgeType create(BiomeDictionary.Type type) {
        return new ForgeType(type);
    }

    public BiomeDictionary.Type getType() {
        return this.type;
    }

    @Override
    public Set<ResourceLocation> getBiomes() {
        return BiomeDictionary.getBiomes((BiomeDictionary.Type)this.type).stream().map(RegistryKey::func_240901_a_).collect(Collectors.toSet());
    }

    @Override
    public Set<RegistryKey<Biome>> getAllBiomes() {
        return this.getBiomes().stream().filter(arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).containsKey(arg_0)).map(r -> RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)r)).collect(Collectors.toSet());
    }

    @Override
    public boolean contains(RegistryKey<Biome> key) {
        return this.contains(key.func_240901_a_());
    }

    @Override
    public boolean contains(Biome biome) {
        return this.contains(biome.getRegistryName());
    }

    @Override
    public boolean contains(ResourceLocation key) {
        return BiomeDictionary.getBiomes((BiomeDictionary.Type)this.type).stream().anyMatch(registryKey -> registryKey.func_240901_a_().equals((Object)key));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ForgeType) {
            return ((ForgeType)obj).getRegistryName().equals((Object)this.getRegistryName());
        }
        return false;
    }

    @Override
    public String toString() {
        String biomes = String.join((CharSequence)", ", this.getBiomes().stream().map(ResourceLocation::toString).sorted().collect(Collectors.toSet()));
        return String.format("name = %s, biomes = [%s]", this.getRegistryName().toString(), biomes);
    }

    @Override
    @Deprecated
    public ForgeType biomes(RegistryKey<Biome> ... biomes) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType biomes(Biome ... biomes) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType biomes(ResourceLocation ... biomes) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType biomes(String modid, String ... biomes) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType addBiomes(Set<ResourceLocation> biomes) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType addBiome(RegistryKey<Biome> biome) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType addBiome(Biome biome) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType addBiome(ResourceLocation biome) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType setBiomes(Set<RegistryKey<Biome>> biomes) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType setBiomesSafe(Set<ResourceLocation> biomes) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType parents(ResourceLocation ... parents) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType parents(BiomeType ... parents) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType addParents(Set<ResourceLocation> parents) {
        return this;
    }

    @Override
    @Deprecated
    public ForgeType addParent(ResourceLocation parent) {
        return this;
    }

    @Override
    @Deprecated
    public Set<ResourceLocation> getParents() {
        return Sets.newHashSet();
    }

    @Override
    @Deprecated
    public ForgeType setParents(Set<ResourceLocation> parents) {
        return this;
    }
}

