/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.legacy.structure_gel.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.biome_dictionary.BiomeType;
import com.legacy.structure_gel.util.Internal;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.TriConsumer;

@Internal
public class StructureGelCompat {
    private static final Logger LOGGER = LogManager.getLogger();

    protected static void init(IEventBus modBus) {
        modBus.addGenericListener(BiomeType.class, StructureGelCompat::registerBiomeDictionary);
    }

    protected static void registerBiomeDictionary(RegistryEvent.Register<BiomeType> event) {
        LOGGER.info("Checking for biome dictionary registry methods in other mods.");
        BiomeDictionary.init();
        StructureGelCompat.registerBiomeDictionaryOld(event);
        StructureGelCompat.compatForEachMod("BiomeDictionaryCompat", (compatClass, modID, mod) -> StructureGelCompat.getMethod(compatClass, "register", String.class).ifPresent(method -> {
            Object returnType = null;
            StructureGelCompat.invokeMethod(method, returnType, modID).ifPresent(result -> result.forEach(t -> {
                BiomeType type = BiomeType.create((ResourceLocation)t.getLeft()).setParents((Set)t.getMiddle()).setBiomesSafe((Set)t.getRight());
                LOGGER.info(modID + " registered a biome type: " + type.toString());
                BiomeDictionary.register(type);
            }));
        }));
    }

    private static void compatForEachMod(String compatClassName, TriConsumer<Class<?>, String, FMLModContainer> consumer) {
        HashSet skippedMods = Sets.newHashSet((Object[])new String[]{"minecraft", "forge"});
        ModList.get().forEachModContainer((modID, modContainer) -> {
            if (modContainer instanceof FMLModContainer && !skippedMods.contains(modID)) {
                FMLModContainer fmlContainer = (FMLModContainer)modContainer;
                try {
                    String compatClassFullName = modContainer.getMod().getClass().getPackage().getName() + ".structure_gel_compat." + compatClassName;
                    try {
                        Class<?> compatClass = Class.forName(compatClassFullName);
                        consumer.accept(compatClass, modID, (Object)fmlContainer);
                    }
                    catch (ClassNotFoundException compatClass) {
                    }
                    catch (ExceptionInInitializerError e) {
                        LOGGER.error(String.format("Found a compatible class %s in the mod %s but it could not be initialized.", compatClassFullName, modID));
                        e.printStackTrace();
                    }
                    catch (LinkageError e) {
                        LOGGER.error(String.format("Something went horribly wrong when trying to load %s from %s.", compatClassFullName, modID));
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    LOGGER.warn(String.format("Encountered an unhandled exception while trying to handle %s in %s.", compatClassName, modID));
                    throwable.printStackTrace();
                }
            }
        });
    }

    private static Optional<Method> getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getMethod(methodName, String.class);
            if (Modifier.isStatic(method.getModifiers())) {
                return Optional.of(clazz.getMethod(methodName, String.class));
            }
            LOGGER.error(String.format("The %s method in %s is not static and it should be.", methodName, clazz.getName()));
            return Optional.empty();
        }
        catch (NoSuchMethodException e) {
            LOGGER.error(String.format("Could not find the %s method in %s.", methodName, clazz.getName()));
            e.printStackTrace();
        }
        catch (SecurityException e) {
            LOGGER.error(String.format("The %s method in %s can not be accessed. It may be private.", methodName, clazz.getName()));
            e.printStackTrace();
        }
        return Optional.empty();
    }

    private static <T> Optional<T> invokeMethod(Method method, T returnTypeInstance, Object ... args) {
        try {
            return Optional.ofNullable(method.invoke(null, args));
        }
        catch (IllegalAccessException e) {
            LOGGER.error(String.format("The method %s can not be accessed. It or the class it's in may be private.", method.getName()));
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(String.format("The arguments passed do not match the arguments required for %s.", method.getName()));
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            LOGGER.error(String.format("The method %s threw an exception.", method.getName()));
            e.printStackTrace();
        }
        return Optional.empty();
    }

    @Deprecated
    public static void registerBiomeDictionaryOld(RegistryEvent.Register<BiomeType> event) {
        try {
            ModList.get().forEachModContainer((s, mc) -> {
                if (mc instanceof FMLModContainer) {
                    FMLModContainer fmlContainer = (FMLModContainer)mc;
                    Method[] methods = new Method[]{};
                    try {
                        methods = fmlContainer.getMod().getClass().getMethods();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    for (Method method : methods) {
                        List result = Lists.newArrayList();
                        if (method.getName().equals("getBiomesSG")) {
                            try {
                                result = (List)method.invoke(fmlContainer.getMod(), new Object[0]);
                            }
                            catch (Throwable e) {
                                LOGGER.info(String.format("Failed to invoke getBiomesSG from %s. Proceeding to the next mod.", s));
                                e.printStackTrace();
                            }
                        }
                        if (result == null || result.isEmpty()) continue;
                        result.forEach(t -> {
                            BiomeType type = BiomeType.create((ResourceLocation)t.getLeft()).setParents((Set)t.getMiddle()).setBiomes((Set)t.getRight());
                            LOGGER.info(s + " registered a biome type: " + type.toString());
                            BiomeDictionary.register(type);
                        });
                    }
                }
            });
        }
        catch (Throwable e) {
            LOGGER.info("Encountered a critical error while trying to load other mods' biome dictionary methods. Skipping this step.");
            e.printStackTrace();
        }
    }
}

