/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel;

import com.legacy.structure_gel.StructureGelConfig;
import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.biome_dictionary.BiomeType;
import com.legacy.structure_gel.commands.StructureGelCommand;
import com.legacy.structure_gel.packets.PacketHandler;
import com.legacy.structure_gel.packets.UpdateGelPlayerPacket;
import com.legacy.structure_gel.util.Internal;
import com.legacy.structure_gel.util.capability.GelCapability;
import com.legacy.structure_gel.util.capability.GelEntityProvider;
import com.legacy.structure_gel.util.capability.IGelEntity;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.RegistryBuilder;

@Internal
public class SGEvents {
    protected static void init(IEventBus modBus, IEventBus forgeBus) {
        modBus.addListener(SGEvents::commonInit);
        modBus.addListener(SGEvents::loadComplete);
        modBus.addListener(SGEvents::createRegistries);
        forgeBus.addListener(SGEvents::registerCommands);
        forgeBus.addListener(SGEvents::onEntityJoinWorld);
        forgeBus.addGenericListener(Entity.class, SGEvents::attachCapabilities);
    }

    protected static void commonInit(FMLCommonSetupEvent event) {
        GelCapability.register();
        PacketHandler.register();
    }

    protected static void loadComplete(FMLLoadCompleteEvent event) {
        try {
            if (StructureGelConfig.COMMON.shouldGuessBiomeDict()) {
                StructureGelMod.LOGGER.info("Attempting to register unregistered biomes to the biome dictionary. This can be disabled via config.");
                BiomeDictionary.makeGuess();
            }
        }
        catch (Exception e) {
            StructureGelMod.LOGGER.error("Encountered an issue while making assumptions for the biome dictionary. Please narrow down which mods cause a conflict here and report it to our issue tracker:");
            StructureGelMod.LOGGER.error("https://gitlab.com/modding-legacy/structure-gel-api/-/issues");
            e.printStackTrace();
        }
    }

    protected static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            GelCapability.ifPresent(player, gelPlayer -> PacketHandler.sendToClient(new UpdateGelPlayerPacket((IGelEntity)gelPlayer), player));
        }
    }

    protected static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        GelEntityProvider provider = new GelEntityProvider();
        event.addCapability(StructureGelMod.locate("gel_entity"), (ICapabilityProvider)provider);
        event.addListener(provider::invalidate);
    }

    protected static void createRegistries(RegistryEvent.NewRegistry event) {
        new RegistryBuilder().setName(StructureGelMod.locate("biome_dictionary")).setType(BiomeType.class).setDefaultKey(StructureGelMod.locate("empty")).create();
    }

    protected static void registerCommands(RegisterCommandsEvent event) {
        StructureGelCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }
}

