/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.energy;

import com.cjm721.overloaded.storage.energy.IHyperHandlerEnergy;
import com.cjm721.overloaded.storage.stacks.bigint.BigIntEnergyStack;
import com.cjm721.overloaded.storage.stacks.intint.LongEnergyStack;
import com.cjm721.overloaded.util.IDataUpdate;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;

public class BigIntEnergyStorage
implements IHyperHandlerEnergy,
INBTSerializable<CompoundNBT> {
    @Nonnull
    private final IDataUpdate dataUpdate;
    @Nonnull
    private BigIntEnergyStack energy = new BigIntEnergyStack(BigInteger.ZERO);

    public BigIntEnergyStorage(@Nonnull IDataUpdate dataUpdate) {
        this.dataUpdate = dataUpdate;
    }

    @Nonnull
    public BigIntEnergyStack bigStatus() {
        return this.energy;
    }

    @Override
    @Nonnull
    public LongEnergyStack status() {
        return new LongEnergyStack(this.energy.amount.min(BigInteger.valueOf(Long.MAX_VALUE)).longValueExact());
    }

    @Override
    @Nonnull
    public LongEnergyStack take(@Nonnull LongEnergyStack stack, boolean doAction) {
        BigInteger takenAmount = this.energy.amount.min(BigInteger.valueOf(stack.amount));
        LongEnergyStack result = new LongEnergyStack(takenAmount.longValueExact());
        if (doAction) {
            this.energy.amount = this.energy.amount.subtract(takenAmount);
            this.dataUpdate.dataUpdated();
        }
        return result;
    }

    @Override
    @Nonnull
    public LongEnergyStack give(@Nonnull LongEnergyStack stack, boolean doAction) {
        if (doAction) {
            this.energy.amount = this.energy.amount.add(BigInteger.valueOf(stack.amount));
            this.dataUpdate.dataUpdated();
        }
        return new LongEnergyStack(0L);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74773_a("Count", this.energy.amount.toByteArray());
        return compound;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.energy = new BigIntEnergyStack(nbt.func_74764_b("Count") ? new BigInteger(nbt.func_74770_j("Count")) : BigInteger.ZERO);
    }
}

