/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityContainer
implements ICapabilityProvider {
    @Nonnull
    private final List<ICapabilityProvider> capabilityProviders = new ArrayList<ICapabilityProvider>();

    public CapabilityContainer addCapability(ICapabilityProvider capabilityProvider) {
        this.capabilityProviders.add(capabilityProvider);
        return this;
    }

    public CapabilityContainer addCapability(Collection<ICapabilityProvider> capabilityProvider) {
        this.capabilityProviders.addAll(capabilityProvider);
        return this;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return this.capabilityProviders.stream().map(cap -> cap.getCapability(capability, facing)).filter(LazyOptional::isPresent).findAny().orElse(LazyOptional.empty());
    }
}

