/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional.armor;

import com.cjm721.overloaded.OverloadedItemGroups;
import com.cjm721.overloaded.item.ModItems;
import com.cjm721.overloaded.item.functional.armor.IMultiArmor;
import com.cjm721.overloaded.storage.builder.CapabilityContainer;
import com.cjm721.overloaded.storage.itemwrapper.IntEnergyWrapper;
import com.cjm721.overloaded.util.IModRegistrable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

abstract class AbstractMultiArmor
extends ArmorItem
implements IModRegistrable,
IMultiArmor {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private static final IArmorMaterial pureMatter = new IArmorMaterial(){

        public int func_200896_a(@Nonnull EquipmentSlotType equipmentSlotType) {
            return -1;
        }

        public int func_200902_b(@Nonnull EquipmentSlotType equipmentSlotType) {
            return 100;
        }

        public int func_200900_a() {
            return 100;
        }

        @Nonnull
        public SoundEvent func_200899_b() {
            return SoundEvents.field_187722_q;
        }

        @Nonnull
        public Ingredient func_200898_c() {
            return Ingredient.field_193370_a;
        }

        public String func_200897_d() {
            return "overloaded:pure_matter";
        }

        public float func_200901_e() {
            return 100.0f;
        }

        public float func_230304_f_() {
            return 100.0f;
        }
    };

    AbstractMultiArmor(EquipmentSlotType equipmentSlot) {
        super(pureMatter, equipmentSlot, new Item.Properties().func_200918_c(-1).func_200917_a(1).func_208103_a(Rarity.EPIC).func_200916_a(OverloadedItemGroups.TECH));
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)ArmorItem.field_96605_cw);
        ModItems.addToSecondaryInit(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(handler -> tooltip.add((ITextComponent)new StringTextComponent("Energy Stored: " + NumberFormat.getInstance().format(handler.getEnergyStored()))));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public int getItemEnchantability(ItemStack stack) {
        return 15;
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return this.getItemStackLimit(stack) == 1;
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean showDurabilityBar(ItemStack p_showDurabilityBar_1_) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        LazyOptional optionalStorage = stack.getCapability(CapabilityEnergy.ENERGY);
        if (optionalStorage.isPresent()) {
            return 1.0 - (Double)optionalStorage.map(energy -> (double)energy.getEnergyStored() / (double)energy.getMaxEnergyStored()).orElseThrow(() -> new RuntimeException("Impossible Condition"));
        }
        return 1.0;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        return stack.func_77978_p();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapabilityContainer().addCapability(this.collectCapabilities(new LinkedList<ICapabilityProvider>(), stack, nbt));
    }

    Collection<ICapabilityProvider> collectCapabilities(@Nonnull Collection<ICapabilityProvider> collection, ItemStack stack, @Nullable CompoundNBT nbt) {
        collection.add(new IntEnergyWrapper(stack));
        return collection;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> func_111205_h(@Nullable EquipmentSlotType equipmentSlot) {
        return HashMultimap.create();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        if (this.hasPower(stack)) {
            HashMultimap multimap = HashMultimap.create((Multimap)super.func_111205_h(slot));
            if (slot == this.func_185083_B_()) {
                multimap.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor modifier", (double)this.func_200881_e(), AttributeModifier.Operation.ADDITION));
                multimap.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor toughness", (double)this.func_200881_e(), AttributeModifier.Operation.ADDITION));
                multimap.put((Object)Attributes.field_233818_a_, (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Max Health", (double)this.func_200881_e() / 2.0, AttributeModifier.Operation.ADDITION));
            }
            return multimap;
        }
        return this.func_111205_h(slot);
    }

    private boolean hasPower(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY).map(storage -> storage.getEnergyStored() > 0).orElse(false);
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        ITextComponent name = super.func_200295_i(stack);
        name.func_150256_b().func_240721_b_(TextFormatting.GOLD);
        return name;
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return false;
    }
}

