/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.client.render.dynamic.ImageUtil;
import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.item.functional.PowerModItem;
import com.cjm721.overloaded.network.packets.RayGunMessage;
import com.cjm721.overloaded.util.WorldUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemRayGun
extends PowerModItem {
    public ItemRayGun() {
        this.setRegistryName("ray_gun");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("The Little Zapper").func_240699_a_(TextFormatting.ITALIC));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("overloaded", "ray_gun"), null);
        ImageUtil.registerDynamicTexture(new ResourceLocation("overloaded", "textures/item/ray_gun.png"), OverloadedConfig.INSTANCE.textureResolutions.itemResolution);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public ActionResult<ItemStack> func_77659_a(World worldIn, @Nonnull PlayerEntity playerIn, @Nonnull Hand handIn) {
        RayTraceResult ray;
        if (!worldIn.field_72995_K) {
            new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        if ((ray = WorldUtil.rayTraceWithEntities(worldIn, playerIn.func_174824_e(Minecraft.func_71410_x().func_184121_ak()), playerIn.func_70676_i(Minecraft.func_71410_x().func_184121_ak()), (Entity)playerIn, OverloadedConfig.INSTANCE.railGun.maxRange)) != null) {
            Overloaded.proxy.networkWrapper.sendToServer((Object)new RayGunMessage(ray.func_216347_e()));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public void handleMessage(ServerPlayerEntity player, RayGunMessage message) {
        ItemStack itemStack = player.func_184586_b(Hand.MAIN_HAND);
        if (itemStack.func_77973_b() != this) {
            return;
        }
        LazyOptional opEnergy = itemStack.getCapability(CapabilityEnergy.ENERGY);
        if (!opEnergy.isPresent()) {
            Overloaded.logger.warn("Railgun has no Energy Capability? NBT: " + itemStack.func_77978_p());
            return;
        }
        IEnergyStorage energy = (IEnergyStorage)opEnergy.orElseThrow(() -> new RuntimeException("Impossible Condition"));
        if (energy.getEnergyStored() < OverloadedConfig.INSTANCE.rayGun.energyPerShot) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Not enough power to fire."), true);
            return;
        }
        Vector3d eyePos = player.func_174824_e(1.0f);
        if (eyePos.func_72438_d(message.vector) > (double)OverloadedConfig.INSTANCE.rayGun.maxRange) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Target out of range."), true);
            return;
        }
        BlockRayTraceResult sanityCheckVec = player.field_70170_p.func_217299_a(new RayTraceContext(eyePos, message.vector, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
        if (sanityCheckVec.func_216346_c() != RayTraceResult.Type.MISS) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Target no longer in sight."), true);
            return;
        }
        energy.extractEnergy(OverloadedConfig.INSTANCE.rayGun.energyPerShot, false);
        LightningBoltEntity entity = new LightningBoltEntity(EntityType.field_200728_aG, player.field_70170_p);
        entity.func_70012_b(message.vector.field_72450_a, message.vector.field_72448_b, message.vector.field_72449_c, 0.0f, 0.0f);
        player.field_70170_p.func_217376_c((Entity)entity);
    }
}

