/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.config;

import com.cjm721.overloaded.config.ConfigSectionHandler;
import com.cjm721.overloaded.config.DevelopmentConfig;
import com.cjm721.overloaded.config.MultiArmorConfig;
import com.cjm721.overloaded.config.MultiToolConfig;
import com.cjm721.overloaded.config.ProductionConfig;
import com.cjm721.overloaded.config.PurifierConfig;
import com.cjm721.overloaded.config.RailGunConfig;
import com.cjm721.overloaded.config.RayGunConfig;
import com.cjm721.overloaded.config.ResolutionConfig;
import com.cjm721.overloaded.config.SpecialConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="overloaded", bus=Mod.EventBusSubscriber.Bus.MOD)
public class OverloadedConfig {
    @Nonnull
    public static final OverloadedConfig INSTANCE = new OverloadedConfig();
    private final Map<ModConfig.Type, ForgeConfigSpec> configSpecs = Maps.newConcurrentMap();
    public final MultiToolConfig multiToolConfig = new MultiToolConfig();
    public final MultiArmorConfig multiArmorConfig = new MultiArmorConfig();
    public final DevelopmentConfig developmentConfig = new DevelopmentConfig();
    public final ResolutionConfig textureResolutions = new ResolutionConfig();
    public final PurifierConfig purifierConfig = new PurifierConfig();
    public final SpecialConfig specialConfig = new SpecialConfig();
    public final RayGunConfig rayGun = new RayGunConfig();
    public final RailGunConfig railGun = new RailGunConfig();
    public final ProductionConfig productionConfig = new ProductionConfig();
    private final ImmutableList<ConfigSectionHandler> configsSections = ImmutableList.of((Object)this.multiToolConfig, (Object)this.multiArmorConfig, (Object)this.developmentConfig, (Object)this.textureResolutions, (Object)this.purifierConfig, (Object)this.specialConfig, (Object)this.rayGun, (Object)this.railGun, (Object)this.productionConfig);

    private OverloadedConfig() {
    }

    @SubscribeEvent
    public static void onLoading(ModConfig.Loading loading) {
        INSTANCE.updateConfigs();
    }

    @SubscribeEvent
    public static void onConfigReloading(ModConfig.Reloading configReloading) {
        INSTANCE.updateConfigs();
    }

    public ForgeConfigSpec getConfig(ModConfig.Type type) {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.configsSections.forEach(c -> c.appendToBuilder(type, builder));
        ForgeConfigSpec spec = builder.build();
        this.configSpecs.put(type, spec);
        return spec;
    }

    private void updateConfigs() {
        this.configsSections.forEach(ConfigSectionHandler::update);
    }
}

