/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.client.render.tile;

import com.cjm721.overloaded.tile.functional.TilePlayerInterface;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.LightType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerInterfaceRenderer
extends TileEntityRenderer<TilePlayerInterface> {
    private UUID uuidCache;
    private ItemStack stackCache;

    public PlayerInterfaceRenderer(TileEntityRendererDispatcher p_i226006_1_) {
        super(p_i226006_1_);
    }

    public void render(@Nonnull TilePlayerInterface te, float v, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer iRenderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        UUID uuid = te.getPlacer();
        if (uuid == null) {
            return;
        }
        PlayerEntity player = te.func_145831_w().func_217371_b(uuid);
        if (player == null) {
            if (!uuid.equals(this.uuidCache)) {
                this.uuidCache = uuid;
                CompoundNBT tag = new CompoundNBT();
                tag.func_74778_a("SkullOwner", uuid.toString());
                this.stackCache = new ItemStack((IItemProvider)Items.field_196184_dx, 1, tag);
            }
            this.renderItem(te, this.stackCache, matrixStack, iRenderTypeBuffer);
            return;
        }
        System.out.printf("\r%d %d", combinedLightIn, combinedOverlayIn);
        this.renderPlayer(te, player, matrixStack, iRenderTypeBuffer, combinedLightIn);
    }

    private void renderPlayer(TilePlayerInterface te, PlayerEntity player, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int lightLevel) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.32, 0.5);
        matrixStack.func_227862_a_(0.2f, 0.2f, 0.2f);
        matrixStack.func_227860_a_();
        long angle = System.currentTimeMillis() / 10L % 360L;
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229180_c_, (float)angle, true));
        Minecraft.func_71410_x().func_175598_ae().func_178633_a(false);
        Minecraft.func_71410_x().func_175598_ae().func_229084_a_((Entity)player, 0.0, 0.0, 0.0, 0.0f, Minecraft.func_71410_x().func_184121_ak(), matrixStack, iRenderTypeBuffer, lightLevel);
        Minecraft.func_71410_x().func_175598_ae().func_178633_a(false);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }

    private void renderItem(TilePlayerInterface te, ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.32, 0.5);
        matrixStack.func_227860_a_();
        long angle = System.currentTimeMillis() / 10L % 360L;
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229180_c_, (float)angle, true));
        RenderSystem.enableLighting();
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GROUND, te.func_145831_w().func_226658_a_(LightType.BLOCK, te.func_174877_v()) * 16, 0, matrixStack, iRenderTypeBuffer);
        RenderSystem.disableLighting();
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }
}

