/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.client.render.item;

import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.item.ModItems;
import com.cjm721.overloaded.util.AssistMode;
import com.cjm721.overloaded.util.BlockItemUseContextPublic;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="overloaded", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RenderMultiToolAssist {
    @SubscribeEvent
    public static void onMouseEvent(InputEvent.MouseScrollEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (event.getScrollDelta() != 0.0 && player != null && player.func_225608_bj_()) {
            ItemStack stack = player.func_184614_ca();
            if (player.func_225608_bj_() && !stack.func_190926_b() && stack.func_77973_b() == ModItems.multiTool) {
                RenderMultiToolAssist.changeHelpMode((int)Math.round(event.getScrollDelta()));
                player.func_146105_b((ITextComponent)new StringTextComponent("Assist Mode: " + RenderMultiToolAssist.getAssistMode().getName()), true);
                event.setCanceled(true);
            }
        }
    }

    private static void changeHelpMode(int dwheel) {
        AssistMode[] values = AssistMode.values();
        int mode = (OverloadedConfig.INSTANCE.multiToolConfig.assistMode + Integer.signum(dwheel)) % values.length;
        if (mode < 0) {
            mode += values.length;
        }
        OverloadedConfig.INSTANCE.multiToolConfig.assistMode = mode;
    }

    @Nonnull
    public static AssistMode getAssistMode() {
        AssistMode[] values = AssistMode.values();
        int mode = OverloadedConfig.INSTANCE.multiToolConfig.assistMode;
        for (AssistMode assistMode : values) {
            if (assistMode.getMode() != mode) continue;
            return assistMode;
        }
        RenderMultiToolAssist.changeHelpMode(0);
        return AssistMode.NONE;
    }

    @SubscribeEvent
    public static void renderWorldLastEvent(RenderWorldLastEvent event) {
        BlockState state;
        float partialTick = Minecraft.func_71410_x().func_184121_ak();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184614_ca().func_77973_b() != ModItems.multiTool) {
            return;
        }
        RayTraceResult resultPick = player.func_213324_a((double)OverloadedConfig.INSTANCE.multiToolConfig.reach, partialTick, false);
        if (resultPick.func_216346_c() == RayTraceResult.Type.MISS || !(resultPick instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)resultPick;
        ItemStack stack = ModItems.multiTool.getSelectedBlockItemStack(player.func_184614_ca());
        if (stack.func_77973_b() instanceof BlockItem) {
            state = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
            state = state.getStateAtViewpoint((IBlockReader)player.func_130014_f_(), result.func_216350_a(), player.func_174824_e(partialTick));
            state = state.func_177230_c().func_196258_a((BlockItemUseContext)new BlockItemUseContextPublic(player.func_130014_f_(), (PlayerEntity)player, Hand.MAIN_HAND, stack, result));
        } else {
            state = Blocks.field_150347_e.func_176223_P();
        }
        switch (RenderMultiToolAssist.getAssistMode()) {
            case PLACE_PREVIEW: {
                if (stack.func_190926_b() || state == null) break;
                RenderMultiToolAssist.renderBlockPreview(event, result, state);
                break;
            }
            case REMOVE_PREVIEW: {
                RenderMultiToolAssist.renderRemovePreview(event, result);
                break;
            }
            case BOTH_PREVIEW: {
                RenderMultiToolAssist.renderRemovePreview(event, result);
                if (stack.func_190926_b() || state == null) break;
                RenderMultiToolAssist.renderBlockPreview(event, result, state);
            }
        }
    }

    private static void renderRemovePreview(RenderWorldLastEvent event, BlockRayTraceResult result) {
        IBakedModel bakeModel = Minecraft.func_71410_x().func_209506_al().func_174953_a(new ModelResourceLocation("overloaded:remove_preview", ""));
        BlockPos toRenderAt = result.func_216350_a();
        RenderMultiToolAssist.renderBlockModel(event, toRenderAt, bakeModel, Blocks.field_150347_e.func_176223_P());
    }

    private static void renderBlockPreview(RenderWorldLastEvent event, BlockRayTraceResult result, @Nonnull BlockState state) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        BlockPos toRenderAt = result.func_216350_a().func_177971_a(result.func_216354_b().func_176730_m());
        RenderMultiToolAssist.renderBlockModel(event, toRenderAt, model, state);
    }

    private static void renderBlockModel(RenderWorldLastEvent event, BlockPos toRenderAt, @Nonnull IBakedModel model, @Nonnull BlockState state) {
        ActiveRenderInfo camera = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        double x = camera.func_216785_c().func_82615_a();
        double y = camera.func_216785_c().func_82617_b();
        double z = camera.func_216785_c().func_82616_c();
        event.getMatrixStack().func_227860_a_();
        event.getMatrixStack().func_227861_a_((double)toRenderAt.func_177958_n() - x, (double)toRenderAt.func_177956_o() - y, (double)toRenderAt.func_177952_p() - z);
        IVertexBuilder buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_().getBuffer(GhostRenderType.getInstance());
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228802_a_((IBlockDisplayReader)Minecraft.func_71410_x().field_71441_e, model, state, toRenderAt, event.getMatrixStack(), buffer, false, Minecraft.func_71410_x().field_71441_e.field_73012_v, 0L, 0);
        event.getMatrixStack().func_227865_b_();
        Minecraft.func_71410_x().func_228019_au_().func_228487_b_().func_228462_a_(GhostRenderType.getInstance());
    }

    public static class GhostRenderType
    extends RenderType {
        public GhostRenderType(String p_i225992_1_, VertexFormat p_i225992_2_, int p_i225992_3_, int p_i225992_4_, boolean p_i225992_5_, boolean p_i225992_6_, Runnable p_i225992_7_, Runnable p_i225992_8_) {
            super(p_i225992_1_, p_i225992_2_, p_i225992_3_, p_i225992_4_, p_i225992_5_, p_i225992_6_, p_i225992_7_, p_i225992_8_);
        }

        public static RenderType getInstance() {
            return GhostRenderType.func_228633_a_((String)"ghost_model", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)7, (int)262144, (boolean)true, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228723_a_(field_228520_l_).func_228719_a_(field_228529_u_).func_228724_a_(field_228521_m_).func_228726_a_(new RenderState.TransparencyState("ghost_transparency", () -> {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }, RenderSystem::disableBlend)).func_228728_a_(true));
        }
    }
}

