/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.client.render.dynamic.general;

import com.cjm721.overloaded.client.render.dynamic.ImageUtil;
import com.cjm721.overloaded.client.resource.BlockResourcePack;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ResizeableTextureGenerator {
    private static final List<ResizableTexture> toCreateTextures = new ArrayList<ResizableTexture>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToTextureQueue(ResizableTexture location) {
        List<ResizableTexture> list = toCreateTextures;
        synchronized (list) {
            toCreateTextures.add(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void texturePre(@Nonnull TextureStitchEvent.Pre event) {
        if (!event.getMap().func_229223_g_().func_110623_a().equals("textures")) {
            return;
        }
        event.addSprite(new ResourceLocation("overloaded", "item/multi_right_arm"));
        event.addSprite(new ResourceLocation("overloaded", "item/multi_left_arm"));
        event.addSprite(new ResourceLocation("overloaded", "item/multi_leg"));
        event.addSprite(new ResourceLocation("overloaded", "item/multi_helmet"));
        event.addSprite(new ResourceLocation("overloaded", "item/multi_body"));
        event.addSprite(new ResourceLocation("overloaded", "item/multi_belt"));
        event.addSprite(new ResourceLocation("overloaded", "item/multi_boot"));
        List<ResizableTexture> list = toCreateTextures;
        synchronized (list) {
            for (ResizableTexture resizableTexture : toCreateTextures) {
                BufferedImage image = null;
                try {
                    image = ImageIO.read(ImageUtil.getTextureInputStream(resizableTexture.originalTexture));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (image == null) continue;
                image = ImageUtil.scaleDownToWidth(image, resizableTexture.resizeToWidth);
                BlockResourcePack.INSTANCE.addImage(resizableTexture.generatedName, image);
                event.getMap().func_195424_a(this.cleanForSprite(resizableTexture.generatedName));
            }
        }
    }

    @Nonnull
    private ResourceLocation cleanForSprite(@Nonnull ResourceLocation location) {
        String path = location.func_110623_a();
        if (path.startsWith("textures/")) {
            return new ResourceLocation(location.func_110624_b(), path.substring(9).replace(".png", ""));
        }
        return location;
    }

    public static class ResizableTexture {
        final ResourceLocation originalTexture;
        final ResourceLocation generatedName;
        final int resizeToWidth;

        public ResizableTexture(ResourceLocation originalTexture, ResourceLocation generatedName, int resizeToWidth) {
            this.originalTexture = originalTexture;
            this.generatedName = generatedName;
            this.resizeToWidth = resizeToWidth;
        }
    }
}

