/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.client.gui;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.capabilities.CapabilityGenericDataStorage;
import com.cjm721.overloaded.client.gui.button.GenericSlider;
import com.cjm721.overloaded.client.gui.button.GuiPositiveFloatTextField;
import com.cjm721.overloaded.client.gui.button.ToggleButton;
import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.item.functional.armor.ItemMultiHelmet;
import com.cjm721.overloaded.network.packets.MultiArmorSettingsMessage;
import com.cjm721.overloaded.storage.IGenericDataStorage;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

@OnlyIn(value=Dist.CLIENT)
public class MultiArmorGuiScreen
extends Screen {
    private GenericSlider flightSpeed;
    private GenericSlider groundSpeed;
    private ToggleButton noClipFlightLock;
    private GuiPositiveFloatTextField flightSpeedTextBox;
    private GuiPositiveFloatTextField groundSpeedTextBox;
    private ToggleButton flightEnabled;
    private ToggleButton feedEnabled;
    private ToggleButton healEnabled;
    private ToggleButton removeHarmfulEnabled;
    private ToggleButton giveAirEnabled;
    private ToggleButton extinguishEnabled;

    public MultiArmorGuiScreen() {
        super((ITextComponent)new StringTextComponent("The TITLE HOW IS THIS SHOWN"));
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        LazyOptional<IGenericDataStorage> opData = MultiArmorGuiScreen.getHelmetDataStorage((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        if (!opData.isPresent()) {
            this.field_230706_i_.func_147108_a(null);
            this.field_230706_i_.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Multi-Helmet not equipped."), true);
            return;
        }
        IGenericDataStorage data = (IGenericDataStorage)opData.orElseThrow(() -> new RuntimeException("Impossible Condition"));
        Map<String, Float> floats = data.getFloatMap();
        Map<String, Boolean> booleans = data.getBooleanMap();
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2, this.field_230709_l_ / 4 + 100, 150, 20, (ITextComponent)new StringTextComponent("Save"), b -> {
            MultiArmorSettingsMessage message = new MultiArmorSettingsMessage((float)this.flightSpeed.getEffectiveValue(), (float)this.groundSpeed.getEffectiveValue(), this.noClipFlightLock.getBooleanState(), this.flightEnabled.getBooleanState(), this.feedEnabled.getBooleanState(), this.healEnabled.getBooleanState(), this.removeHarmfulEnabled.getBooleanState(), this.giveAirEnabled.getBooleanState(), this.extinguishEnabled.getBooleanState());
            Overloaded.proxy.networkWrapper.sendToServer((Object)message);
            this.field_230706_i_.func_147108_a(null);
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 150, this.field_230709_l_ / 4 + 100, 150, 20, (ITextComponent)new StringTextComponent("Cancel"), b -> this.field_230706_i_.func_147108_a(null)));
        float flightSpeedValue = floats.getOrDefault("flight_speed", Float.valueOf(0.1f)).floatValue();
        this.flightSpeed = (GenericSlider)this.func_230480_a_((Widget)new GenericSlider(this.field_230708_k_ / 2 - 150, this.field_230709_l_ / 4, 0.0f, (float)OverloadedConfig.INSTANCE.multiArmorConfig.maxFlightSpeed, flightSpeedValue, "Flight Speed:"));
        this.flightSpeedTextBox = (GuiPositiveFloatTextField)this.func_230480_a_((Widget)new GuiPositiveFloatTextField(this.field_230712_o_, this.flightSpeed.field_230690_l_, this.flightSpeed.field_230691_m_, this.flightSpeed.func_230998_h_(), this.flightSpeed.func_238483_d_(), flightSpeedValue, 0.0f, (float)OverloadedConfig.INSTANCE.multiArmorConfig.maxFlightSpeed));
        this.flightSpeedTextBox.func_146189_e(false);
        this.flightEnabled = (ToggleButton)this.func_230480_a_((Widget)new ToggleButton(this.field_230708_k_ / 2 - 150, this.field_230709_l_ / 4 + 20, booleans.getOrDefault("flight", true), "Flight:"));
        float groundSpeedValue = floats.getOrDefault("ground_speed", Float.valueOf(0.2f)).floatValue();
        this.groundSpeed = (GenericSlider)this.func_230480_a_((Widget)new GenericSlider(this.field_230708_k_ / 2, this.field_230709_l_ / 4, 0.0f, (float)OverloadedConfig.INSTANCE.multiArmorConfig.maxGroundSpeed, groundSpeedValue, "Ground Speed:"));
        this.groundSpeedTextBox = (GuiPositiveFloatTextField)this.func_230480_a_((Widget)new GuiPositiveFloatTextField(this.field_230712_o_, this.groundSpeed.field_230690_l_, this.groundSpeed.field_230691_m_, this.groundSpeed.func_230998_h_(), this.groundSpeed.func_238483_d_(), groundSpeedValue, 0.0f, (float)OverloadedConfig.INSTANCE.multiArmorConfig.maxGroundSpeed));
        this.groundSpeedTextBox.func_146189_e(false);
        this.feedEnabled = (ToggleButton)this.func_230480_a_((Widget)new ToggleButton(this.field_230708_k_ / 2, this.field_230709_l_ / 4 + 20, booleans.getOrDefault("feed", true), "Feeder:"));
        this.healEnabled = (ToggleButton)this.func_230480_a_((Widget)new ToggleButton(this.field_230708_k_ / 2 - 150, this.field_230709_l_ / 4 + 40, booleans.getOrDefault("heal", true), "Healer:"));
        this.removeHarmfulEnabled = (ToggleButton)this.func_230480_a_((Widget)new ToggleButton(this.field_230708_k_ / 2, this.field_230709_l_ / 4 + 40, booleans.getOrDefault("remove_harmful", true), "Remove Harmful Potions:"));
        this.giveAirEnabled = (ToggleButton)this.func_230480_a_((Widget)new ToggleButton(this.field_230708_k_ / 2 - 150, this.field_230709_l_ / 4 + 60, booleans.getOrDefault("give_air", true), "Airer:"));
        this.extinguishEnabled = (ToggleButton)this.func_230480_a_((Widget)new ToggleButton(this.field_230708_k_ / 2, this.field_230709_l_ / 4 + 60, booleans.getOrDefault("extinguish", true), "Extinguisher:"));
        this.noClipFlightLock = (ToggleButton)this.func_230480_a_((Widget)new ToggleButton(this.field_230708_k_ / 2 - 75, this.field_230709_l_ / 4 + 80, booleans.getOrDefault("noclip_flight_lock", true), "No Clip Flight Lock:"));
    }

    @Nullable
    private static LazyOptional<IGenericDataStorage> getHelmetDataStorage(PlayerEntity player) {
        for (ItemStack stack : player.func_184193_aE()) {
            if (!(stack.func_77973_b() instanceof ItemMultiHelmet)) continue;
            return stack.getCapability(CapabilityGenericDataStorage.GENERIC_DATA_STORAGE);
        }
        return LazyOptional.empty();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        this.flightSpeedTextBox.func_231044_a_(mouseX, mouseY, mouseButton);
        this.groundSpeedTextBox.func_231044_a_(mouseX, mouseY, mouseButton);
        switch (mouseButton) {
            case 0: {
                break;
            }
            case 1: {
                if (this.flightSpeed.field_230694_p_) {
                    this.flightSpeedTextBox.func_146189_e(true);
                    this.flightSpeed.field_230694_p_ = false;
                    this.flightSpeedTextBox.func_146180_a(Float.toString((float)this.flightSpeed.getEffectiveValue()));
                    this.groundSpeedTextBox.func_146189_e(true);
                    this.groundSpeed.field_230694_p_ = false;
                    this.groundSpeedTextBox.func_146180_a(Float.toString((float)this.groundSpeed.getEffectiveValue()));
                    break;
                }
                this.flightSpeedTextBox.func_146189_e(false);
                this.flightSpeed.field_230694_p_ = true;
                this.flightSpeed.setBasedOnEffectiveValue(this.flightSpeedTextBox.getFloatValue());
                this.groundSpeedTextBox.func_146189_e(false);
                this.groundSpeed.field_230694_p_ = true;
                this.groundSpeed.setBasedOnEffectiveValue(this.groundSpeedTextBox.getFloatValue());
                break;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }
}

