/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block.basic.container;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.block.basic.container.AbstractBlockHyperContainer;
import com.cjm721.overloaded.client.render.dynamic.general.ResizeableTextureGenerator;
import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.storage.stacks.intint.LongFluidStack;
import com.cjm721.overloaded.tile.infinity.TileAlmostInfiniteTank;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockAlmostInfiniteTank
extends AbstractBlockHyperContainer {
    public BlockAlmostInfiniteTank() {
        super(BlockAlmostInfiniteTank.getDefaultProperties());
        this.setRegistryName("almost_infinite_tank");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("overloaded", "almost_infinite_tank"), null);
        ResizeableTextureGenerator.addToTextureQueue(new ResizeableTextureGenerator.ResizableTexture(new ResourceLocation("overloaded", "textures/block/almost_infinite_tank.png"), new ResourceLocation("overloaded", "textures/dynamic/blocks/almost_infinite_tank.png"), OverloadedConfig.INSTANCE.textureResolutions.blockResolution));
    }

    @Nonnull
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileAlmostInfiniteTank();
    }

    @Override
    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(handIn);
        if (heldItem.func_190926_b() && handIn == Hand.MAIN_HAND) {
            if (!world.field_72995_K) {
                this.sendPlayerStatus(world, pos, player);
            }
            return ActionResultType.SUCCESS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileAlmostInfiniteTank) {
            LazyOptional opHandler = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            if (!opHandler.isPresent()) {
                Overloaded.logger.warn("Infinite Tank has no HyperFluid Capability? " + pos);
            } else {
                if (!world.field_72995_K) {
                    return FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (IFluidHandler)((IFluidHandler)opHandler.orElseThrow(() -> new RuntimeException("Impossible Condition")))) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    protected void sendPlayerStatus(World world, BlockPos pos, PlayerEntity player) {
        LongFluidStack storedFluid = ((TileAlmostInfiniteTank)world.func_175625_s(pos)).getStorage().getFluidStack();
        if (storedFluid == null || storedFluid.fluidStack == null) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Fluid: EMPTY"), false);
        } else {
            player.func_146105_b((ITextComponent)new StringTextComponent("Fluid: ").func_230529_a_(storedFluid.fluidStack.getDisplayName()).func_240702_b_(String.format(" Amount: %,d", storedFluid.amount)), false);
        }
    }
}

