/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block.basic;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.block.ModBlock;
import com.cjm721.overloaded.client.render.dynamic.ImageUtil;
import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.tile.functional.TileInfiniteWaterSource;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockInfiniteWaterSource
extends ModBlock {
    public BlockInfiniteWaterSource() {
        super(BlockInfiniteWaterSource.getDefaultProperties().func_226896_b_());
        this.setRegistryName("infinite_water_source");
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("overloaded", "infinite_water_source"), null);
        ImageUtil.registerDynamicTexture(new ResourceLocation("overloaded", "textures/block/infinite_water_source.png"), OverloadedConfig.INSTANCE.textureResolutions.blockResolution);
    }

    @Nonnull
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileInfiniteWaterSource();
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te;
        ItemStack heldItem = player.func_184586_b(handIn);
        if (!heldItem.func_190926_b() && (te = world.func_175625_s(pos)) instanceof TileInfiniteWaterSource) {
            LazyOptional opHandler = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            if (!opHandler.isPresent()) {
                Overloaded.logger.warn("Infinite Tank has no HyperFluid Capability? " + pos);
            } else {
                if (!world.field_72995_K) {
                    return FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (IFluidHandler)((IFluidHandler)opHandler.orElseThrow(() -> new RuntimeException("Impossible Condition")))) ? ActionResultType.CONSUME : ActionResultType.FAIL;
                }
                return ActionResultType.CONSUME;
            }
        }
        return ActionResultType.PASS;
    }
}

