/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.conjurer_illager.entity;

import com.legacy.conjurer_illager.registry.IllagerEntityTypes;
import com.legacy.conjurer_illager.registry.IllagerSounds;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class BouncingBallEntity
extends ThrowableEntity {
    private static final DataParameter<Integer> BALL_TYPE = EntityDataManager.func_187226_a(BouncingBallEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BOUNCES = EntityDataManager.func_187226_a(BouncingBallEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public BouncingBallEntity(EntityType<? extends BouncingBallEntity> type, World world) {
        super(type, world);
    }

    public BouncingBallEntity(EntityType<? extends BouncingBallEntity> type, LivingEntity thrower, World world) {
        super(type, thrower, world);
    }

    public BouncingBallEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(IllagerEntityTypes.BOUNCING_BALL, world);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("ballType", this.getBallType());
        compound.func_74768_a("totalBounces", this.getTotalBounces());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setBallType(compound.func_74762_e("ballType"));
        this.setTotalBounces(compound.func_74762_e("totalBounces"));
    }

    protected void func_70184_a(RayTraceResult result) {
        BlockRayTraceResult traceResult;
        BlockState blockstate;
        RayTraceResult.Type raytraceresult$type = result.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.BLOCK && !(blockstate = this.field_70170_p.func_180495_p((traceResult = (BlockRayTraceResult)result).func_216350_a())).func_196952_d((IBlockReader)this.field_70170_p, traceResult.func_216350_a()).func_197766_b()) {
            Direction face = traceResult.func_216354_b();
            blockstate.func_215690_a(this.field_70170_p, blockstate, traceResult, (Entity)this);
            Vec3d motion = this.func_213322_ci();
            double motionX = motion.func_82615_a();
            double motionY = motion.func_82617_b();
            double motionZ = motion.func_82616_c();
            if (face == Direction.EAST) {
                motionX = -motionX;
            } else if (face == Direction.SOUTH) {
                motionZ = -motionZ;
            } else if (face == Direction.WEST) {
                motionX = -motionX;
            } else if (face == Direction.NORTH) {
                motionZ = -motionZ;
            } else if (face == Direction.UP) {
                motionY = -motionY;
            } else if (face == Direction.DOWN) {
                motionY = -motionY;
            }
            this.func_213293_j(motionX, motionY, motionZ);
            if (this.field_70173_aa > 200 || this.getTotalBounces() > 20) {
                this.func_184185_a(IllagerSounds.ENTITY_BOUNCY_BALL_VANISH, 1.0f, 2.0f);
                this.func_70106_y();
            } else {
                this.func_184185_a(IllagerSounds.ENTITY_BOUNCY_BALL_BOUNCE, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.setTotalBounces(this.getTotalBounces() + 1);
            }
        }
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)result).func_216348_a();
            if (this.func_85052_h() != null && !entity.func_184191_r((Entity)this.func_85052_h()) && !(entity instanceof RabbitEntity)) {
                int i = 5 + this.field_70170_p.func_175659_aa().func_151525_a();
                if (!entity.func_190530_aW()) {
                    entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()).func_76351_m(), (float)i);
                    this.func_184185_a(SoundEvents.field_187544_ad, 0.5f, 2.0f);
                    this.func_184185_a(IllagerSounds.ENTITY_BOUNCY_BALL_VANISH, 1.0f, 2.0f);
                    this.func_70106_y();
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(1.01));
        }
        if (this.field_70173_aa > 360 || this.field_70173_aa > 150 && this.field_70170_p.func_226660_f_(this.func_180425_c()) || this.func_85052_h() != null && !this.func_85052_h().func_70089_S()) {
            this.func_184185_a(IllagerSounds.ENTITY_BOUNCY_BALL_VANISH, 1.0f, 2.0f);
            this.func_70106_y();
        }
        for (int i = 0; i < 2; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), this.field_70146_Z.nextGaussian() * 0.1, 0.0, this.field_70146_Z.nextGaussian() * 0.1);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BALL_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(BOUNCES, (Object)0);
    }

    public int getBallType() {
        return (Integer)this.field_70180_af.func_187225_a(BALL_TYPE);
    }

    public void setBallType(int type) {
        this.field_70180_af.func_187227_b(BALL_TYPE, (Object)type);
    }

    public int getTotalBounces() {
        return (Integer)this.field_70180_af.func_187225_a(BOUNCES);
    }

    public void setTotalBounces(int bounces) {
        this.field_70180_af.func_187227_b(BOUNCES, (Object)bounces);
    }
}

