/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.conjurer_illager;

import com.legacy.conjurer_illager.ConjurerIllagerMod;
import com.legacy.conjurer_illager.item.IllagerArmorMaterial;
import com.legacy.conjurer_illager.item.MagicianHatItem;
import com.legacy.conjurer_illager.item.ThrowableBallItem;
import com.legacy.conjurer_illager.registry.IllagerEntityTypes;
import com.legacy.conjurer_illager.registry.IllagerParticles;
import com.legacy.conjurer_illager.registry.IllagerSounds;
import com.legacy.conjurer_illager.registry.IllagerStructures;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="conjurer_illager", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IllagerRegistry {
    public static final Item CONJURER_HAT = new MagicianHatItem(IllagerArmorMaterial.CONJURER_HAT, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(ItemGroup.field_78037_j));
    public static final Item CONJURER_SPAWN_EGG = new SpawnEggItem(IllagerEntityTypes.CONJURER, 7415387, 15179338, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
    public static final Item THROWABLE_BALL = new ThrowableBallItem(new Item.Properties().func_200916_a(null));
    public static final PaintingType THEATRE_PAINTING = new PaintingType(32, 32);

    @SubscribeEvent
    public static void registerParticles(RegistryEvent.Register<ParticleType<?>> event) {
        IllagerParticles.init(event);
    }

    @SubscribeEvent
    public static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        IllagerParticles.registerFactories(event);
    }

    @SubscribeEvent
    public static void onRegisterPaintings(RegistryEvent.Register<PaintingType> event) {
        IllagerRegistry.register(event.getRegistry(), "theatre", THEATRE_PAINTING);
    }

    @SubscribeEvent
    public static void onRegisterSounds(RegistryEvent.Register<SoundEvent> event) {
        IllagerSounds.init(event);
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IllagerRegistry.register(event.getRegistry(), "conjurer_hat", CONJURER_HAT);
        IllagerRegistry.register(event.getRegistry(), "conjurer_spawn_egg", CONJURER_SPAWN_EGG);
        IllagerRegistry.register(event.getRegistry(), "throwable_ball", THROWABLE_BALL);
    }

    @SubscribeEvent
    public static void onRegisterEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        IllagerEntityTypes.init(event);
    }

    @SubscribeEvent
    public static void onRegisterFeatures(RegistryEvent.Register<Feature<?>> event) {
        IllagerStructures.init(event);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, String name, T object) {
        object.setRegistryName(ConjurerIllagerMod.locate(name));
        registry.register(object);
    }
}

