/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.laggoggles.client.gui;

import com.github.terminatornl.laggoggles.client.gui.QuickText;
import com.github.terminatornl.laggoggles.packet.ObjectData;
import com.github.terminatornl.laggoggles.profiler.ProfileResult;
import com.github.terminatornl.laggoggles.profiler.ScanType;
import com.github.terminatornl.laggoggles.util.Calculations;
import com.github.terminatornl.laggoggles.util.Graphical;
import com.github.terminatornl.laggoggles.util.RunInClientThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class LagOverlayGui {
    private final Minecraft MINECRAFT;
    private final RenderManager RENDER_MANAGER;
    private final FontRenderer FONT_RENDERER;
    private final HashMap<BlockPos, String> BLOCKS_NANO = new HashMap();
    private final HashMap<BlockPos, Double> BLOCKS_HEAT = new HashMap();
    private final HashMap<Entity, String> ENTITY_NANO = new HashMap();
    private final HashMap<Entity, Double> ENTITY_HEAT = new HashMap();
    private final ProfileResult result;
    private AtomicBoolean isShowing = new AtomicBoolean(false);
    private double flash = 1.0;
    private boolean flashIncreasing = false;
    private final HashMap<ChunkPos, Double> CHUNKS = new HashMap();
    private final ScanType type;
    private static AtomicReference<LagOverlayGui> INSTANCE = new AtomicReference();
    private final QuickText quickText;
    private Runnable TIMELY_UPDATES = new Runnable(){

        @Override
        public void run() {
            while (LagOverlayGui.this.isShowing.get()) {
                try {
                    Thread.sleep(1000L);
                    new RunInClientThread(new Runnable(){

                        @Override
                        public void run() {
                            if (LagOverlayGui.this.isShowing.get()) {
                                LagOverlayGui.this.scanAndAddEntities();
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    };

    public static void create(ProfileResult data) {
        if (INSTANCE.get() != null) {
            INSTANCE.get()._hide();
        }
        INSTANCE.set(new LagOverlayGui(data));
    }

    public static void destroy() {
        if (INSTANCE.get() != null) {
            INSTANCE.get()._hide();
            INSTANCE.set(null);
        }
    }

    public static void show() {
        if (INSTANCE.get() != null && !LagOverlayGui.INSTANCE.get().isShowing.get()) {
            INSTANCE.get()._show();
        }
    }

    public static void hide() {
        if (INSTANCE.get() != null && LagOverlayGui.INSTANCE.get().isShowing.get()) {
            INSTANCE.get()._hide();
        }
    }

    public static boolean isShowing() {
        return INSTANCE.get() != null && LagOverlayGui.INSTANCE.get().isShowing.get();
    }

    private LagOverlayGui(ProfileResult data) {
        this.result = data;
        this.type = this.result.getType();
        this.MINECRAFT = Minecraft.func_71410_x();
        this.RENDER_MANAGER = this.MINECRAFT.func_175598_ae();
        this.FONT_RENDERER = this.MINECRAFT.field_71466_p;
        this.quickText = new QuickText(this.result.getType().getText(this.result));
        this.scanAndAddEntities();
    }

    private void calculateFlash() {
        if (this.flashIncreasing) {
            this.flash += 0.005;
            if (this.flash >= 1.0) {
                this.flashIncreasing = false;
            }
        } else {
            this.flash -= 0.005;
            if (this.flash <= 0.125) {
                this.flashIncreasing = true;
            }
        }
    }

    private synchronized void scanAndAddEntities() {
        this.BLOCKS_NANO.clear();
        this.BLOCKS_HEAT.clear();
        this.ENTITY_NANO.clear();
        this.ENTITY_HEAT.clear();
        this.CHUNKS.clear();
        if (this.MINECRAFT.func_147113_T() || this.MINECRAFT.field_71441_e == null || this.MINECRAFT.field_71441_e.field_72996_f == null) {
            return;
        }
        if (this.type == ScanType.WORLD) {
            for (ObjectData objectData : this.result.getData()) {
                long nanos = (Long)objectData.getValue(ObjectData.Entry.NANOS);
                block0 : switch (objectData.type) {
                    case TILE_ENTITY: 
                    case BLOCK: {
                        BlockPos pos;
                        if (((Integer)objectData.getValue(ObjectData.Entry.WORLD_ID)).intValue() != this.MINECRAFT.field_71441_e.field_73011_w.getDimension() || this.MINECRAFT.field_71439_g.func_174818_b(pos = new BlockPos(((Integer)objectData.getValue(ObjectData.Entry.BLOCK_POS_X)).intValue(), ((Integer)objectData.getValue(ObjectData.Entry.BLOCK_POS_Y)).intValue(), ((Integer)objectData.getValue(ObjectData.Entry.BLOCK_POS_Z)).intValue())) > 36864.0) break;
                        double heat = Calculations.heat(nanos, this.result);
                        this.BLOCKS_HEAT.put(pos, heat);
                        this.BLOCKS_NANO.put(pos, Calculations.muPerTickString(nanos, this.result));
                        ChunkPos c = new ChunkPos(pos);
                        if (!this.CHUNKS.containsKey(c)) {
                            this.CHUNKS.put(c, heat);
                        } else {
                            this.CHUNKS.put(c, heat + this.CHUNKS.get(c));
                        }
                        if (!(heat < 0.0) || this.CHUNKS.get(c) != 0.0) break;
                        this.CHUNKS.remove(c);
                        break;
                    }
                    case ENTITY: {
                        if (((Integer)objectData.getValue(ObjectData.Entry.WORLD_ID)).intValue() != this.MINECRAFT.field_71441_e.field_73011_w.getDimension()) break;
                        UUID entityID = (UUID)objectData.getValue(ObjectData.Entry.ENTITY_UUID);
                        for (Entity entity : new ArrayList(this.MINECRAFT.field_71441_e.field_72996_f)) {
                            if (!entity.getPersistentID().equals(entityID) || entity == this.MINECRAFT.field_71439_g) continue;
                            this.ENTITY_NANO.put(entity, Calculations.muPerTickString(nanos, this.result));
                            this.ENTITY_HEAT.put(entity, Calculations.heat(nanos, this.result));
                            break block0;
                        }
                        break;
                    }
                }
            }
        } else {
            for (ObjectData objectData : this.result.getData()) {
                long nanos = (Long)objectData.getValue(ObjectData.Entry.NANOS);
                block4 : switch (objectData.type) {
                    case GUI_BLOCK: {
                        BlockPos pos = new BlockPos(((Integer)objectData.getValue(ObjectData.Entry.BLOCK_POS_X)).intValue(), ((Integer)objectData.getValue(ObjectData.Entry.BLOCK_POS_Y)).intValue(), ((Integer)objectData.getValue(ObjectData.Entry.BLOCK_POS_Z)).intValue());
                        this.BLOCKS_HEAT.put(pos, Calculations.heatNF(nanos, this.result));
                        this.BLOCKS_NANO.put(pos, Calculations.NFString(nanos, this.result.getTotalFrames()));
                        break;
                    }
                    case GUI_ENTITY: {
                        UUID entityID = (UUID)objectData.getValue(ObjectData.Entry.ENTITY_UUID);
                        for (Entity entity : new ArrayList(this.MINECRAFT.field_71441_e.field_72996_f)) {
                            if (!entity.getPersistentID().equals(entityID) || entity == this.MINECRAFT.field_71439_g) continue;
                            this.ENTITY_HEAT.put(entity, Calculations.heatNF(nanos, this.result));
                            this.ENTITY_NANO.put(entity, Calculations.NFString(nanos, this.result.getTotalFrames()));
                            break block4;
                        }
                        break;
                    }
                }
            }
        }
    }

    private void mark(int x, int y, int z, double heat) {
        double[] c = Graphical.heatToColor(heat);
        GL11.glColor4d((double)c[0], (double)c[1], (double)c[2], (double)Math.min(heat / 100.0, this.flash));
        GL11.glVertex3d((double)x, (double)(y + 1), (double)z);
        GL11.glVertex3d((double)(x + 1), (double)(y + 1), (double)z);
        GL11.glVertex3d((double)(x + 1), (double)y, (double)z);
        GL11.glVertex3d((double)x, (double)y, (double)z);
        GL11.glVertex3d((double)(x + 1), (double)y, (double)(z + 1));
        GL11.glVertex3d((double)(x + 1), (double)y, (double)z);
        GL11.glVertex3d((double)(x + 1), (double)(y + 1), (double)z);
        GL11.glVertex3d((double)(x + 1), (double)(y + 1), (double)(z + 1));
        GL11.glVertex3d((double)(x + 1), (double)(y + 1), (double)(z + 1));
        GL11.glVertex3d((double)x, (double)(y + 1), (double)(z + 1));
        GL11.glVertex3d((double)x, (double)y, (double)(z + 1));
        GL11.glVertex3d((double)(x + 1), (double)y, (double)(z + 1));
        GL11.glVertex3d((double)x, (double)(y + 1), (double)(z + 1));
        GL11.glVertex3d((double)x, (double)(y + 1), (double)z);
        GL11.glVertex3d((double)x, (double)y, (double)z);
        GL11.glVertex3d((double)x, (double)y, (double)(z + 1));
        GL11.glVertex3d((double)x, (double)(y + 1), (double)z);
        GL11.glVertex3d((double)x, (double)(y + 1), (double)(z + 1));
        GL11.glVertex3d((double)(x + 1), (double)(y + 1), (double)(z + 1));
        GL11.glVertex3d((double)(x + 1), (double)(y + 1), (double)z);
        GL11.glVertex3d((double)(x + 1), (double)y, (double)z);
        GL11.glVertex3d((double)(x + 1), (double)y, (double)(z + 1));
        GL11.glVertex3d((double)x, (double)y, (double)(z + 1));
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    private void drawChunk(ChunkPos chunk, Double heat, double pY) {
        double[] c = Graphical.heatToColor(heat / 10.0);
        GL11.glColor4d((double)c[0], (double)c[1], (double)c[2], (double)0.4);
        int xStart = chunk.func_180334_c();
        int zStart = chunk.func_180333_d();
        int xEnd = chunk.func_180332_e() + 1;
        int zEnd = chunk.func_180330_f() + 1;
        GL11.glVertex3d((double)xEnd, (double)(pY + 80.0), (double)zStart);
        GL11.glVertex3d((double)xEnd, (double)(pY + 80.0), (double)zEnd);
        GL11.glVertex3d((double)xStart, (double)(pY + 80.0), (double)zEnd);
        GL11.glVertex3d((double)xStart, (double)(pY + 80.0), (double)zStart);
    }

    @SubscribeEvent
    public void onDraw(RenderWorldLastEvent event) {
        float partialTicks = event.getPartialTicks();
        double pX = this.MINECRAFT.field_71439_g.field_70169_q + (this.MINECRAFT.field_71439_g.field_70165_t - this.MINECRAFT.field_71439_g.field_70169_q) * (double)partialTicks;
        double pY = this.MINECRAFT.field_71439_g.field_70167_r + (this.MINECRAFT.field_71439_g.field_70163_u - this.MINECRAFT.field_71439_g.field_70167_r) * (double)partialTicks;
        double pZ = this.MINECRAFT.field_71439_g.field_70166_s + (this.MINECRAFT.field_71439_g.field_70161_v - this.MINECRAFT.field_71439_g.field_70166_s) * (double)partialTicks;
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-pX), (double)(-pY), (double)(-pZ));
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glHint((int)3154, (int)4354);
        this.calculateFlash();
        this.drawBlocksAndChunks(pY);
        this.drawEntities(partialTicks);
        this.drawTileEntityTags();
        this.drawEntityTags(partialTicks);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void highLightMob(Entity entity, double heat, float partialTicks) {
        double pZ;
        double pY;
        double pX;
        double[] c = Graphical.heatToColor(heat);
        GL11.glColor4d((double)c[0], (double)c[1], (double)c[2], (double)0.6);
        if (entity.field_70128_L) {
            pX = entity.field_70165_t;
            pY = entity.field_70163_u;
            pZ = entity.field_70161_v;
        } else {
            pX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
            pY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks;
            pZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        }
        GL11.glVertex3d((double)pX, (double)pY, (double)pZ);
        GL11.glVertex3d((double)pX, (double)(pY + 2.3), (double)pZ);
    }

    private void drawBlocksAndChunks(double pY) {
        GL11.glBegin((int)7);
        for (Map.Entry<BlockPos, Double> entry : this.BLOCKS_HEAT.entrySet()) {
            if (!(entry.getValue() > 1.0)) continue;
            this.mark(entry.getKey().func_177958_n(), entry.getKey().func_177956_o(), entry.getKey().func_177952_p(), entry.getValue());
        }
        for (Map.Entry<BlockPos, Double> entry : this.CHUNKS.entrySet()) {
            this.drawChunk((ChunkPos)entry.getKey(), entry.getValue(), pY);
        }
        GL11.glEnd();
    }

    private void drawEntities(float partialTicks) {
        GL11.glBegin((int)1);
        for (Map.Entry<Entity, Double> e : this.ENTITY_HEAT.entrySet()) {
            this.highLightMob(e.getKey(), e.getValue(), partialTicks);
        }
        GL11.glEnd();
    }

    private void drawTileEntityTags() {
        GL11.glEnable((int)3553);
        for (Map.Entry<BlockPos, String> e : this.BLOCKS_NANO.entrySet()) {
            GL11.glPushMatrix();
            double offX = (double)e.getKey().func_177958_n() + 0.5;
            double offY = (double)e.getKey().func_177956_o() + 0.5;
            double offZ = (double)e.getKey().func_177952_p() + 0.5;
            GL11.glTranslated((double)offX, (double)offY, (double)offZ);
            GL11.glRotated((double)(-this.RENDER_MANAGER.field_78735_i), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)this.RENDER_MANAGER.field_78732_j, (double)1.0, (double)0.0, (double)0.0);
            GL11.glScaled((double)-0.015, (double)-0.015, (double)0.015);
            this.FONT_RENDERER.func_78276_b(e.getValue(), -this.FONT_RENDERER.func_78256_a(e.getValue()) / 2, 0, 0xCCCCCC);
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3553);
    }

    private synchronized void drawEntityTags(float partialTicks) {
        for (Map.Entry<Entity, String> e : this.ENTITY_NANO.entrySet()) {
            double pZe;
            double pYe;
            double pXe;
            GL11.glPushMatrix();
            Entity entity = e.getKey();
            if (entity.field_70128_L) {
                pXe = entity.field_70165_t;
                pYe = entity.field_70163_u;
                pZe = entity.field_70161_v;
            } else {
                pXe = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
                pYe = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks;
                pZe = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
            }
            GL11.glTranslated((double)pXe, (double)(pYe + 2.3), (double)pZe);
            GL11.glRotated((double)(-this.RENDER_MANAGER.field_78735_i), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)this.RENDER_MANAGER.field_78732_j, (double)1.0, (double)0.0, (double)0.0);
            GL11.glScaled((double)-0.015, (double)-0.015, (double)0.015);
            double[] c = Graphical.heatToColor(this.ENTITY_HEAT.get(entity));
            GL11.glColor4d((double)c[0], (double)c[1], (double)c[2], (double)0.6);
            GL11.glBegin((int)7);
            String text = e.getValue();
            if (entity.field_70128_L) {
                text = text + " (" + entity.func_70005_c_() + ")";
            }
            int width_plus_2 = this.FONT_RENDERER.func_78256_a(text) + 2;
            int height_div_2_plus_1 = this.FONT_RENDERER.field_78288_b / 2 + 1;
            GL11.glVertex3d((double)0.0, (double)(-height_div_2_plus_1), (double)0.0);
            GL11.glVertex3d((double)0.0, (double)(height_div_2_plus_1 - 1), (double)0.0);
            GL11.glVertex3d((double)width_plus_2, (double)(height_div_2_plus_1 - 1), (double)0.0);
            GL11.glVertex3d((double)width_plus_2, (double)(-height_div_2_plus_1), (double)0.0);
            GL11.glEnd();
            GL11.glEnable((int)3553);
            GL11.glColor4d((double)0.0, (double)0.0, (double)0.0, (double)1.0);
            this.FONT_RENDERER.func_78276_b(text, 1, -this.FONT_RENDERER.field_78288_b / 2, 0);
            GL11.glDisable((int)3553);
            GL11.glPopMatrix();
        }
    }

    private void _hide() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.quickText.hide();
        this.isShowing.set(false);
    }

    private void _show() {
        this.isShowing.set(true);
        new Thread(this.TIMELY_UPDATES).start();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.quickText.show();
    }
}

