/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.laggoggles;

import com.github.terminatornl.laggoggles.CommonProxy;
import com.github.terminatornl.laggoggles.client.ClientProxy;
import com.github.terminatornl.laggoggles.profiler.ProfileManager;
import com.github.terminatornl.tickcentral.api.TickHub;
import com.github.terminatornl.tickcentral.api.TickInterceptor;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="laggoggles", name="LagGoggles", version="1.12.2-5.8-132", acceptableRemoteVersions="*", guiFactory="com.github.terminatornl.laggoggles.client.gui.GuiInGameConfigFactory", dependencies="required:tickcentral@[2.4,);", acceptedMinecraftVersions="[1.12.2]")
@IFMLLoadingPlugin.SortingIndex(value=1001)
public class Main
implements TickInterceptor {
    public static final String MODID = "LagGoggles";
    public static final String MODID_LOWER = "laggoggles";
    public static final String VERSION = "1.12.2-5.8-132";
    public static final Logger LOGGER = LogManager.getLogger((String)"LagGoggles");
    @SidedProxy(modId="laggoggles", serverSide="com.github.terminatornl.laggoggles.CommonProxy", clientSide="com.github.terminatornl.laggoggles.client.ClientProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent e) {
        proxy.preinit(e);
        LOGGER.info("Registered sided proxy for: " + (proxy instanceof ClientProxy ? "Client" : "Dedicated server"));
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent e) {
        proxy.postinit(e);
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent e) {
        proxy.serverStartingEvent(e);
        TickHub.INTERCEPTOR = this;
    }

    public void redirectUpdateTick(Block block, World worldIn, BlockPos pos, IBlockState state, Random random) {
        if (ProfileManager.PROFILER_ENABLED_UPDATE_SAFE) {
            long LAGGOGGLES_START = System.nanoTime();
            TickHub.trueUpdateTick((Block)block, (World)worldIn, (BlockPos)pos, (IBlockState)state, (Random)random);
            ProfileManager.timingManager.addBlockTime(worldIn.field_73011_w.getDimension(), pos, System.nanoTime() - LAGGOGGLES_START);
        } else {
            TickHub.trueUpdateTick((Block)block, (World)worldIn, (BlockPos)pos, (IBlockState)state, (Random)random);
        }
    }

    public void redirectRandomTick(Block block, World worldIn, BlockPos pos, IBlockState state, Random random) {
        if (ProfileManager.PROFILER_ENABLED_UPDATE_SAFE) {
            long LAGGOGGLES_START = System.nanoTime();
            TickHub.trueRandomTick((Block)block, (World)worldIn, (BlockPos)pos, (IBlockState)state, (Random)random);
            ProfileManager.timingManager.addBlockTime(worldIn.field_73011_w.getDimension(), pos, System.nanoTime() - LAGGOGGLES_START);
        } else {
            TickHub.trueRandomTick((Block)block, (World)worldIn, (BlockPos)pos, (IBlockState)state, (Random)random);
        }
    }

    public void redirectUpdate(ITickable tickable) {
        if (ProfileManager.PROFILER_ENABLED_UPDATE_SAFE && tickable instanceof TileEntity) {
            long LAGGOGGLES_START = System.nanoTime();
            TickHub.trueUpdate((ITickable)tickable);
            long time = System.nanoTime() - LAGGOGGLES_START;
            TileEntity tile = (TileEntity)tickable;
            ProfileManager.timingManager.addBlockTime(tile.func_145831_w().field_73011_w.getDimension(), tile.func_174877_v(), time);
        } else {
            TickHub.trueUpdate((ITickable)tickable);
        }
    }

    public void redirectOnUpdate(Entity entity) {
        if (ProfileManager.PROFILER_ENABLED_UPDATE_SAFE) {
            long LAGGOGGLES_START = System.nanoTime();
            TickHub.trueOnUpdate((Entity)entity);
            ProfileManager.timingManager.addEntityTime(entity.field_71093_bK, entity.getPersistentID(), System.nanoTime() - LAGGOGGLES_START);
        } else {
            TickHub.trueOnUpdate((Entity)entity);
        }
    }
}

